/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;

public class TemplateNode
extends BaseNode {
    private static final Engine engine = Engine.create((String)"template", e -> e.addSharedStaticMethod(StringUtil.class));
    private String template;
    private String outputDef;

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getOutputDef() {
        return this.outputDef;
    }

    public void setOutputDef(String outputDef) {
        this.outputDef = outputDef;
    }

    protected Map<String, Object> execute(Chain chain) {
        Map parameters = this.getParameters(chain);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Template templateByString = engine.getTemplateByString(this.template);
        templateByString.render(parameters, (OutputStream)result);
        String outputDef = this.outputDef;
        if (StringUtil.noText((String)outputDef)) {
            outputDef = "output";
        }
        return Maps.of((String)outputDef, (Object)result.toString());
    }

    public String toString() {
        return "TemplateNode{template='" + this.template + '\'' + ", outputDef='" + this.outputDef + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", async=" + this.async + ", inwardEdges=" + this.inwardEdges + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + this.nodeStatus + '}';
    }
}

