/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.parser;

import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.JsCodeCondition;
import com.agentsflex.core.chain.NodeCondition;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import dev.tinyflow.core.Tinyflow;
import dev.tinyflow.core.parser.NodeParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseNodeParser
implements NodeParser {
    private static final JSONObject EMPTY_JSON_OBJECT = new JSONObject(Collections.emptyMap());

    public JSONObject getData(JSONObject nodeObject) {
        JSONObject jsonObject = nodeObject.getJSONObject("data");
        return jsonObject != null ? jsonObject : EMPTY_JSON_OBJECT;
    }

    public void addParameters(BaseNode node, JSONObject data) {
        List<Parameter> inputParameters = this.getParameters(data, "parameters");
        node.setParameters(inputParameters);
    }

    public List<Parameter> getParameters(JSONObject data, String key) {
        return this.getParameters(data.getJSONArray(key));
    }

    public List<Parameter> getParameters(JSONArray parametersJsonArray) {
        if (parametersJsonArray == null || parametersJsonArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(parametersJsonArray.size());
        for (int i = 0; i < parametersJsonArray.size(); ++i) {
            JSONObject parameterJsonObject = parametersJsonArray.getJSONObject(i);
            Parameter parameter = new Parameter();
            parameter.setId(parameterJsonObject.getString("id"));
            parameter.setName(parameterJsonObject.getString("name"));
            parameter.setDescription(parameterJsonObject.getString("description"));
            parameter.setDataType(DataType.ofValue((String)parameterJsonObject.getString("dataType")));
            parameter.setRef(parameterJsonObject.getString("ref"));
            parameter.setRefType(RefType.ofValue((String)parameterJsonObject.getString("refType")));
            parameter.setRequired(parameterJsonObject.getBooleanValue("required"));
            parameter.setDefaultValue(parameterJsonObject.getString("defaultValue"));
            parameter.setValue(parameterJsonObject.getString("value"));
            JSONArray children = parameterJsonObject.getJSONArray("children");
            if (children != null && !children.isEmpty()) {
                parameter.addChildren(this.getParameters(children));
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    public void addOutputDefs(BaseNode node, JSONObject data) {
        JSONArray outputDefs = data.getJSONArray("outputDefs");
        if (outputDefs == null || outputDefs.isEmpty()) {
            return;
        }
        for (int i = 0; i < outputDefs.size(); ++i) {
            JSONObject outputDefJsonObject = outputDefs.getJSONObject(i);
            Parameter parameter = new Parameter();
            parameter.setId(outputDefJsonObject.getString("id"));
            parameter.setName(outputDefJsonObject.getString("name"));
            parameter.setDescription(outputDefJsonObject.getString("description"));
            parameter.setRef(outputDefJsonObject.getString("ref"));
            parameter.setValue(outputDefJsonObject.getString("value"));
            parameter.setDefaultValue(outputDefJsonObject.getString("defaultValue"));
            parameter.setRefType(RefType.ofValue((String)outputDefJsonObject.getString("refType")));
            parameter.setDataType(DataType.ofValue((String)outputDefJsonObject.getString("dataType")));
            JSONArray children = outputDefJsonObject.getJSONArray("children");
            if (children != null && !children.isEmpty()) {
                parameter.addChildren(this.getParameters(children));
            }
            node.addOutputDef(parameter);
        }
    }

    @Override
    public ChainNode parse(JSONObject nodeJSONObject, Tinyflow tinyflow) {
        JSONObject data = this.getData(nodeJSONObject);
        BaseNode node = this.doParse(nodeJSONObject, data, tinyflow);
        if (node != null) {
            node.setId(nodeJSONObject.getString("id"));
            node.setName(nodeJSONObject.getString("label"));
            node.setDescription(nodeJSONObject.getString("description"));
            if (!data.isEmpty()) {
                String loopBreakCondition;
                Integer maxLoopCount;
                Long loopIntervalMs;
                Boolean loopEnable;
                String description;
                String name;
                Boolean async;
                this.addParameters(node, data);
                this.addOutputDefs(node, data);
                String conditionString = data.getString("condition");
                if (StringUtil.hasText((String)conditionString)) {
                    node.setCondition((NodeCondition)new JsCodeCondition(conditionString.trim()));
                }
                if ((async = data.getBoolean("async")) != null) {
                    node.setAsync(async.booleanValue());
                }
                if (StringUtil.hasText((String)(name = data.getString("title")))) {
                    node.setName(name);
                }
                if (StringUtil.hasText((String)(description = data.getString("description")))) {
                    node.setDescription(description);
                }
                if ((loopEnable = data.getBoolean("loopEnable")) != null) {
                    node.setLoopEnable(loopEnable.booleanValue());
                }
                if ((loopIntervalMs = data.getLong("loopIntervalMs")) != null) {
                    node.setLoopIntervalMs(loopIntervalMs.longValue());
                }
                if ((maxLoopCount = data.getInteger("maxLoopCount")) != null) {
                    node.setMaxLoopCount(maxLoopCount.intValue());
                }
                if (StringUtil.hasText((String)(loopBreakCondition = data.getString("loopBreakCondition")))) {
                    node.setLoopBreakCondition((NodeCondition)new JsCodeCondition(loopBreakCondition.trim()));
                }
            }
        }
        return node;
    }

    protected abstract BaseNode doParse(JSONObject var1, JSONObject var2, Tinyflow var3);
}

