/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.codegen.pui9.model;

import es.prodevelop.codegen.pui9.enums.ClientControlType;
import es.prodevelop.codegen.pui9.model.ColumnType;
import es.prodevelop.codegen.pui9.model.ColumnVisibility;
import es.prodevelop.codegen.pui9.model.DatabaseColumnType;
import es.prodevelop.codegen.pui9.model.Entity;
import es.prodevelop.codegen.pui9.model.GeometryType;
import es.prodevelop.codegen.pui9.model.JavaAttributeType;
import es.prodevelop.codegen.pui9.model.client.IControlConfiguration;
import es.prodevelop.codegen.pui9.model.client.IMaxLengthControlConfiguration;
import es.prodevelop.codegen.pui9.model.client.IRequiredControlConfiguration;
import es.prodevelop.codegen.pui9.utils.CodegenUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class Column
implements Serializable,
Comparable<Column> {
    private static final long serialVersionUID = 1L;
    private transient Entity entity;
    private transient String javaTypeString;
    private transient Integer javaSize;
    private transient boolean pk;
    private transient boolean sequence;
    private transient boolean geometry;
    private transient GeometryType geometryType;
    private transient DatabaseColumnType dbType;
    private transient String dbRawType;
    private transient String dbDefaultValue;
    private transient Integer dbSize;
    private transient Integer dbDecimals;
    private transient String javaName;
    private transient JavaAttributeType javaType;
    private transient JavaAttributeType javaSubType;
    private transient ColumnType columnType;
    private transient boolean lang;
    private transient String clientTranslation = "";
    private transient boolean clientInForm = true;
    private transient boolean clientInHeader = false;
    private transient ClientControlType clientControlType;
    private transient IControlConfiguration controlConfiguration;
    private String dbName;
    private String javaClassName;
    private ColumnVisibility columnVisibility;
    private boolean nullable;
    private boolean autoincrementable;
    private String autowhere;
    private String javaDefaultValue;
    private int position;

    public Column() {
        this.setClientControlType(ClientControlType.TEXT);
        try {
            this.setControlConfiguration(this.clientControlType.configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public String getJavaTypeString() {
        return this.javaTypeString;
    }

    public Integer getJavaSize() {
        return this.javaSize;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName.toLowerCase();
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public DatabaseColumnType getDbType() {
        return this.dbType;
    }

    public void setDbType(DatabaseColumnType dbType) {
        this.dbType = dbType;
    }

    public String getDbRawType() {
        return this.dbRawType;
    }

    public void setDbRawType(String dbRawType) {
        this.dbRawType = dbRawType;
    }

    public String getDbDefaultValue() {
        return this.dbDefaultValue;
    }

    public void setDbDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue == null) {
            dbDefaultValue = "";
        }
        this.dbDefaultValue = dbDefaultValue;
    }

    public Integer getDbSize() {
        return this.dbSize;
    }

    public void setDbSize(Integer dbSize) {
        if (dbSize == null) {
            dbSize = -1;
        }
        if (DatabaseColumnType.CLOB.equals((Object)this.dbType)) {
            dbSize = -1;
        }
        this.dbSize = dbSize;
        if (this.controlConfiguration instanceof IMaxLengthControlConfiguration) {
            ((IMaxLengthControlConfiguration)this.controlConfiguration).setMaxlength(dbSize != null ? dbSize : null);
        }
    }

    public Integer getDbDecimals() {
        return this.dbDecimals;
    }

    public void setDbDecimals(Integer dbDecimals) {
        if (dbDecimals == null) {
            dbDecimals = 0;
        }
        this.dbDecimals = dbDecimals;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public JavaAttributeType getJavaType() {
        return this.javaType;
    }

    public JavaAttributeType getJavaSubType() {
        return this.javaSubType;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public String getJavaDefaultValue() {
        return this.javaDefaultValue;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public ColumnVisibility getColumnVisibility() {
        return this.columnVisibility;
    }

    public void setColumnVisibility(ColumnVisibility columnVisibility) {
        this.columnVisibility = columnVisibility;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        if (this.controlConfiguration instanceof IRequiredControlConfiguration) {
            ((IRequiredControlConfiguration)this.controlConfiguration).setRequired(!nullable);
        }
    }

    public boolean isPk() {
        return this.pk;
    }

    public void setPk(boolean pk) {
        this.pk = pk;
    }

    public boolean isAutoincrementable() {
        return this.autoincrementable;
    }

    public void setAutoincrementable(boolean autoincrementable) {
        this.autoincrementable = autoincrementable;
    }

    public String getAutowhere() {
        return this.autowhere;
    }

    public void setAutowhere(String autowhere) {
        this.autowhere = autowhere;
        this.entity.setWithAutowhere(this.entity.isWithAutowhere() || !StringUtils.isEmpty((CharSequence)autowhere));
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public void setSequence(boolean sequence) {
        this.sequence = sequence;
        if (sequence) {
            this.javaDefaultValue = "";
        }
    }

    public boolean isGeometry() {
        return this.geometry;
    }

    public void setGeometry(boolean geometry) {
        this.geometry = geometry;
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(GeometryType geometryType) {
        this.geometryType = geometryType;
    }

    public boolean isLang() {
        return this.lang;
    }

    public void setLang(boolean lang) {
        this.lang = lang;
    }

    public String getClientTranslation() {
        return this.clientTranslation;
    }

    public void setClientTranslation(String clientTranslation) {
        this.clientTranslation = clientTranslation;
    }

    public boolean isClientInForm() {
        return this.clientInForm;
    }

    public void setClientInForm(boolean clientInForm) {
        this.clientInForm = clientInForm;
    }

    public boolean isClientInHeader() {
        return this.clientInHeader;
    }

    public void setClientInHeader(boolean clientInHeader) {
        this.clientInHeader = clientInHeader;
    }

    public ClientControlType getClientControlType() {
        return this.clientControlType;
    }

    public void setClientControlType(ClientControlType clientControlType) {
        this.clientControlType = clientControlType;
    }

    public IControlConfiguration getControlConfiguration() {
        return this.controlConfiguration;
    }

    public void setControlConfiguration(IControlConfiguration controlConfiguration) {
        this.controlConfiguration = controlConfiguration;
        if (this.controlConfiguration instanceof IMaxLengthControlConfiguration) {
            ((IMaxLengthControlConfiguration)this.controlConfiguration).setMaxlength(this.dbSize != null ? this.dbSize : null);
        }
        if (this.controlConfiguration instanceof IRequiredControlConfiguration) {
            ((IRequiredControlConfiguration)this.controlConfiguration).setRequired(!this.nullable);
        }
    }

    public void computeJavaAttributes() {
        this.setAutowhere(this.autowhere);
        this.setJavaName();
        this.setJavaType();
        this.setJavaDefaultValue();
    }

    private void setJavaName() {
        this.javaName = CodegenUtils.convertColumnNameToJavaName(this.dbName);
    }

    private void setJavaType() {
        if (this.dbType == null || StringUtils.isEmpty((CharSequence)this.dbRawType)) {
            return;
        }
        switch (this.dbType) {
            case ARRAY: {
                this.javaType = JavaAttributeType.LIST;
                this.columnType = ColumnType.text;
                if (this.dbRawType.contains(DatabaseColumnType.VARCHAR.name().toLowerCase()) || this.dbRawType.contains(DatabaseColumnType.LONGVARCHAR.name().toLowerCase()) || this.dbRawType.contains(DatabaseColumnType.TEXT.name().toLowerCase()) || this.dbRawType.contains(DatabaseColumnType.CLOB.name().toLowerCase())) {
                    this.javaSubType = JavaAttributeType.STRING;
                    break;
                }
                if (this.dbRawType.contains(DatabaseColumnType.CHAR.name().toLowerCase())) {
                    this.javaSubType = JavaAttributeType.CHARACTER;
                    break;
                }
                if (this.dbRawType.contains(DatabaseColumnType.BIT.name().toLowerCase())) {
                    this.javaSubType = JavaAttributeType.BOOLEAN;
                    break;
                }
                if (this.dbRawType.contains(DatabaseColumnType.TINYINT.name().toLowerCase())) {
                    this.javaSubType = JavaAttributeType.BYTE;
                    break;
                }
                if (this.dbRawType.contains(DatabaseColumnType.INTEGER.name().toLowerCase()) || this.dbRawType.contains(DatabaseColumnType.INT.name().toLowerCase())) {
                    this.javaSubType = JavaAttributeType.INTEGER;
                    break;
                }
                if (this.dbRawType.contains(DatabaseColumnType.BIGINT.name().toLowerCase())) {
                    this.javaSubType = JavaAttributeType.LONG;
                    break;
                }
                if (this.dbRawType.contains(DatabaseColumnType.REAL.name().toLowerCase()) || this.dbRawType.contains(DatabaseColumnType.DOUBLE.name().toLowerCase()) || this.dbRawType.contains(DatabaseColumnType.DECIMAL.name().toLowerCase()) || this.dbRawType.contains(DatabaseColumnType.NUMERIC.name().toLowerCase()) || this.dbRawType.contains(DatabaseColumnType.FLOAT.name().toLowerCase())) {
                    this.javaSubType = JavaAttributeType.BIGDECIMAL;
                    break;
                }
                if (!this.dbRawType.contains(DatabaseColumnType.DATE.name().toLowerCase()) && !this.dbRawType.contains(DatabaseColumnType.TIME.name().toLowerCase()) && !this.dbRawType.contains(DatabaseColumnType.TIMESTAMP.name().toLowerCase())) break;
                this.javaSubType = JavaAttributeType.DATETIME;
                break;
            }
            case CHAR: 
            case NCHAR: {
                this.javaType = this.dbSize <= 1 ? JavaAttributeType.CHARACTER : JavaAttributeType.STRING;
                this.columnType = ColumnType.text;
                break;
            }
            case VARCHAR: 
            case NVARCHAR: 
            case LONGVARCHAR: 
            case CLOB: 
            case BLOB: 
            case DISTINCT: 
            case STRUCT: 
            case VARBINARY: 
            case TEXT: {
                this.javaType = JavaAttributeType.STRING;
                this.columnType = ColumnType.text;
                break;
            }
            case OTHER: {
                if (this.geometry) {
                    this.javaType = JavaAttributeType.STRING;
                    this.columnType = ColumnType.text;
                    break;
                }
                this.javaType = JavaAttributeType.OBJECT;
                this.columnType = ColumnType.json;
                break;
            }
            case BIT: 
            case BOOLEAN: {
                this.javaType = JavaAttributeType.BOOLEAN;
                this.columnType = ColumnType.logic;
                break;
            }
            case TINYINT: {
                this.javaType = JavaAttributeType.BYTE;
                this.columnType = ColumnType.text;
                break;
            }
            case SMALLINT: {
                this.javaType = JavaAttributeType.SHORT;
                this.columnType = ColumnType.numeric;
                break;
            }
            case INTEGER: 
            case INT: {
                this.javaType = JavaAttributeType.INTEGER;
                this.columnType = ColumnType.numeric;
                break;
            }
            case BIGINT: {
                this.javaType = JavaAttributeType.LONG;
                this.columnType = ColumnType.numeric;
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                if (this.dbDecimals == 0) {
                    this.javaType = this.dbSize <= 22 || this.dbSize == 38 ? JavaAttributeType.INTEGER : JavaAttributeType.LONG;
                    this.columnType = ColumnType.numeric;
                    break;
                }
                this.javaType = JavaAttributeType.BIGDECIMAL;
                this.columnType = ColumnType.decimal;
                break;
            }
            case REAL: 
            case DOUBLE: 
            case FLOAT: {
                this.javaType = JavaAttributeType.BIGDECIMAL;
                this.columnType = ColumnType.decimal;
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_TIMEZONE: 
            case TIMESTAMP_LOCAL_TIMEZONE: {
                this.javaType = JavaAttributeType.DATETIME;
                this.columnType = ColumnType.datetime;
                break;
            }
            default: {
                this.javaType = JavaAttributeType.OBJECT;
                this.columnType = ColumnType.text;
            }
        }
        if (this.dbRawType.toLowerCase().startsWith("timestamp")) {
            this.javaType = JavaAttributeType.DATETIME;
            this.columnType = ColumnType.datetime;
        }
        this.javaTypeString = (this.javaType.clazz.getName().contains("java.lang") ? this.javaType.clazz.getSimpleName() : this.javaType.clazz.getName()) + (this.javaSubType == null ? "" : "<" + this.javaSubType.clazz.getName() + ">");
        this.javaSize = this.javaType.equals((Object)JavaAttributeType.STRING) ? this.dbSize : -1;
    }

    private void setJavaDefaultValue() {
        if (this.javaDefaultValue != null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.dbDefaultValue) || this.dbDefaultValue.equalsIgnoreCase("null") || this.dbDefaultValue.equalsIgnoreCase("(null)")) {
            this.javaDefaultValue = "";
            return;
        }
        String pattern = "[^\\w\\s\\-]";
        switch (this.dbType) {
            case CHAR: 
            case NCHAR: {
                this.javaDefaultValue = this.dbDefaultValue;
                break;
            }
            case VARCHAR: 
            case NVARCHAR: 
            case LONGVARCHAR: 
            case CLOB: 
            case BLOB: 
            case DISTINCT: 
            case STRUCT: 
            case VARBINARY: 
            case OTHER: {
                if (this.dbDefaultValue.contains("'")) {
                    this.javaDefaultValue = "\"" + this.dbDefaultValue.substring(this.dbDefaultValue.indexOf(39) + 1, this.dbDefaultValue.lastIndexOf(39)) + "\"";
                    break;
                }
                this.javaDefaultValue = "\"" + this.dbDefaultValue + "\"";
                break;
            }
            case BIT: 
            case BOOLEAN: {
                this.javaDefaultValue = this.dbDefaultValue.trim();
                break;
            }
            case TINYINT: {
                this.javaDefaultValue = "new " + Byte.class.getSimpleName() + "(\"" + this.dbDefaultValue.replaceAll(pattern, "").trim() + "\")";
                break;
            }
            case SMALLINT: {
                this.javaDefaultValue = this.dbDefaultValue.replaceAll(pattern, "").trim();
                break;
            }
            case INTEGER: {
                this.javaDefaultValue = this.dbDefaultValue.replaceAll(pattern, "").trim();
                break;
            }
            case BIGINT: {
                this.javaDefaultValue = this.dbDefaultValue.replaceAll(pattern, "").trim() + "L";
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                String val = this.dbDefaultValue.replaceAll(pattern, "").trim();
                if (JavaAttributeType.INTEGER.equals((Object)this.javaType)) {
                    this.javaDefaultValue = val;
                    break;
                }
                if (JavaAttributeType.LONG.equals((Object)this.javaType)) {
                    this.javaDefaultValue = val + "L";
                    break;
                }
                if (!JavaAttributeType.BIGDECIMAL.equals((Object)this.javaType)) break;
                this.javaDefaultValue = "new " + BigDecimal.class.getName() + "(\"" + val + "\")";
                break;
            }
            case REAL: 
            case DOUBLE: 
            case FLOAT: {
                this.javaDefaultValue = "new " + BigDecimal.class.getName() + "(\"" + this.dbDefaultValue.replaceAll(pattern, "").trim() + "\")";
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_TIMEZONE: 
            case TIMESTAMP_LOCAL_TIMEZONE: {
                this.javaDefaultValue = this.getDateDefaultValue();
                break;
            }
            case ARRAY: {
                this.javaDefaultValue = "new " + ArrayList.class.getName() + "<>()";
                break;
            }
            default: {
                this.javaDefaultValue = null;
            }
        }
    }

    private String getDateDefaultValue() {
        if (this.dbDefaultValue == null) {
            return null;
        }
        String parsed = this.dbDefaultValue.toLowerCase().replace("(", "").replace(")", "").replace("'", "").trim();
        if (parsed.equals("null")) {
            return null;
        }
        boolean today = false;
        String toFormatPuiMethod = "es.prodevelop.pui9.utils.PuiDateUtil.stringToInstant(\"%s\")";
        switch (this.entity.getConfiguration().getDatabase().getType()) {
            case ORACLE: {
                if (parsed.contains("sysdate") || parsed.contains("current_timestamp")) {
                    today = true;
                    break;
                }
                if (!parsed.contains("date") && !parsed.contains("timestamp") || !(parsed = parsed.replace("date", "").replace("timestamp", "").trim()).contains(",")) break;
                parsed = parsed.split(",")[0];
                break;
            }
            case SQL_SERVER: {
                if (!parsed.contains("getdate") && !parsed.contains("getutcdate") && !parsed.contains("sysdatetime") && !parsed.contains("sysutcdatetime")) break;
                today = true;
                break;
            }
            case POSTGRE_SQL: {
                if (!parsed.contains("now") && !parsed.contains("current_date")) break;
                today = true;
            }
        }
        if (today) {
            return "java.time.Instant.now()";
        }
        return String.format(toFormatPuiMethod, parsed);
    }

    public String toString() {
        return "DB name: " + this.dbName + "\nDB type: " + (Object)((Object)this.dbType) + "\nJava name: " + this.javaName + "\nJava type: " + (Object)((Object)this.javaType) + "\nPK: " + this.pk + "\nNullable: " + this.nullable + "\nAutoincrementable: " + this.autoincrementable + "\nSequence: " + this.sequence + "\nGeometry: " + this.geometry;
    }

    @Override
    public int compareTo(Column otherColumn) {
        if (this.position < otherColumn.getPosition()) {
            return -1;
        }
        if (this.position == otherColumn.getPosition()) {
            return 0;
        }
        return 1;
    }
}

