/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.codegen.pui9.model;

import es.prodevelop.codegen.pui9.enums.ClientControlType;
import es.prodevelop.codegen.pui9.model.Column;
import es.prodevelop.codegen.pui9.model.DatabaseColumnType;
import es.prodevelop.codegen.pui9.model.JavaAttributeType;
import es.prodevelop.codegen.pui9.model.PuiConfiguration;
import es.prodevelop.codegen.pui9.utils.CodegenUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class Entity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient PuiConfiguration configuration;
    private transient boolean withGeometry;
    private transient boolean withAutowhere;
    private transient String javaName;
    private transient String lowercaseName;
    private String dbName;
    private List<Column> columns;

    public PuiConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PuiConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isWithGeometry() {
        return this.withGeometry;
    }

    public boolean isWithAutowhere() {
        return this.withAutowhere;
    }

    public void setWithAutowhere(boolean withAutowhere) {
        this.withAutowhere = withAutowhere;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
        this.computeAttributes();
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getLowercaseName() {
        return this.lowercaseName;
    }

    public List<Column> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        return this.columns;
    }

    public void addColumn(Column column) {
        Optional<Column> existColOpt = this.getColumns().stream().filter(c -> c.getDbName().equals(column.getDbName())).findFirst();
        Column existentColumn = null;
        if (!existColOpt.isPresent()) {
            this.getColumns().add(column.getPosition(), column);
            existentColumn = column;
        } else {
            existentColumn = existColOpt.get();
            existentColumn.setPk(column.isPk());
            existentColumn.setNullable(column.isNullable());
            existentColumn.setSequence(column.isSequence());
            existentColumn.setGeometry(column.isGeometry());
            existentColumn.setGeometryType(column.getGeometryType());
            existentColumn.setDbType(column.getDbType());
            existentColumn.setDbRawType(column.getDbRawType());
            existentColumn.setDbDefaultValue(column.getDbDefaultValue());
            existentColumn.setDbSize(column.getDbSize());
            existentColumn.setDbDecimals(column.getDbDecimals());
            existentColumn.setPosition(column.getPosition());
        }
        existentColumn.computeJavaAttributes();
        this.withGeometry |= existentColumn.isGeometry();
        this.getColumns().sort((c1, c2) -> Integer.compare(c1.getPosition(), c2.getPosition()));
    }

    public void mergeColumns(List<Column> columns) {
        this.getColumns().removeIf(origColumn -> columns.stream().filter(newColumn -> newColumn.getDbName().equals(origColumn.getDbName())).count() == 0L);
        columns.forEach(this::addColumn);
    }

    public void removeWrongColumns(List<String> validColumns) {
        this.getColumns().removeIf(column -> !validColumns.contains(column.getDbName()));
    }

    public void reorderColumns() {
        Collections.sort(this.getColumns());
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public List<Column> getColumnsOfType(ClientControlType clientControlType) {
        return this.getColumnsOfType(clientControlType.name());
    }

    public List<Column> getColumnsOfType(String clientControlType) {
        ClientControlType type = ClientControlType.valueOf(clientControlType);
        return this.columns.stream().filter(column -> column.isClientInForm() && column.getClientControlType().equals((Object)type)).collect(Collectors.toList());
    }

    public void computeAttributes() {
        this.setJavaName();
    }

    private void setJavaName() {
        this.javaName = CodegenUtils.getJavaName(this.dbName);
        this.lowercaseName = this.javaName.toLowerCase();
    }

    public String checkColumnsType() {
        StringBuilder sb = new StringBuilder();
        String dateMessageError = "Column ''{0}'' DB type is {1}\n";
        for (Column column : this.columns) {
            if (!column.getJavaType().equals((Object)JavaAttributeType.DATETIME)) continue;
            switch (this.configuration.getDatabase().getType()) {
                case ORACLE: {
                    if (column.getDbType().equals((Object)DatabaseColumnType.TIMESTAMP_TIMEZONE)) break;
                    sb.append(MessageFormat.format(dateMessageError, new Object[]{column.getDbName(), column.getDbType()}));
                    break;
                }
                case POSTGRE_SQL: {
                    if (!column.getDbType().equals((Object)DatabaseColumnType.DATE) && !column.getDbType().equals((Object)DatabaseColumnType.TIMESTAMP)) break;
                    sb.append(MessageFormat.format(dateMessageError, new Object[]{column.getDbName(), column.getDbType()}));
                    break;
                }
                case SQL_SERVER: {
                    if (!column.getDbType().equals((Object)DatabaseColumnType.DATE) && !column.getDbType().equals((Object)DatabaseColumnType.TIMESTAMP)) break;
                    sb.append(MessageFormat.format(dateMessageError, new Object[]{column.getDbName(), column.getDbType()}));
                }
            }
        }
        String dateMessageSolution = "\nBetter change them to ''{0}''";
        if (!sb.toString().isEmpty()) {
            switch (this.configuration.getDatabase().getType()) {
                case ORACLE: {
                    sb.append(MessageFormat.format(dateMessageSolution, "TIMESTAMP WITH TIME ZONE"));
                    break;
                }
                case POSTGRE_SQL: {
                    sb.append(MessageFormat.format(dateMessageSolution, "TIMESTAMPTZ(3)"));
                    break;
                }
                case SQL_SERVER: {
                    sb.append(MessageFormat.format(dateMessageSolution, "DATETIME"));
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "DB name: " + this.dbName + "\nJava name: " + this.javaName + "\nWith geometry: " + this.withGeometry;
    }
}

