<#compress>
package ${config.server.basePackage}.model.dto;

<#assign dtoHasColumns = (config.selectedTable.columns?size > config.selectedTable.primaryKeys?size)>
import es.prodevelop.pui9.enums.ColumnType;
import es.prodevelop.pui9.annotations.PuiField;
import es.prodevelop.pui9.annotations.PuiGenerated;
import es.prodevelop.pui9.utils.PuiObjectUtils;

import es.prodevelop.pui9.model.dto.AbstractTableDto;
import ${config.server.basePackage}.model.dto.interfaces.I${config.selectedTable.javaName}Pk;

<#if config.pui9Version.withLombok>
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.With;
import lombok.experimental.SuperBuilder;
	<#assign anyDefault = false>
	<#list config.selectedTable.columns as column>
		<#assign anyDefault = anyDefault || column.javaDefaultValue?has_content>
	</#list>
	<#if anyDefault || config.selectedTable.translationTable??>
import lombok.Builder;
	</#if>
</#if>

<#if config.pui9Version.withLombok>
@Data
@SuperBuilder(builderMethodName = "pkBuilder")
@With
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
</#if>
@PuiGenerated
public class ${config.selectedTable.javaName}Pk extends AbstractTableDto implements I${config.selectedTable.javaName}Pk {

	@PuiGenerated
	private static final long serialVersionUID = 1L;

<#list config.selectedTable.primaryKeys as pk>
	@PuiGenerated
	<#if config.pui9Version.withLombok && pk.javaDefaultValue?has_content>
	@Builder.Default
	</#if>
	@PuiField(columnname = I${config.selectedTable.javaName}Pk.${pk.dbName?upper_case}_COLUMN, ispk = true, nullable = false, type = ColumnType.${pk.columnType}, autoincrementable = ${pk.autoincrementable?c}, maxlength = ${pk.javaSize?c}, islang = false, isgeometry = ${pk.geometry?c}, issequence = ${pk.sequence?c})
	private ${pk.javaTypeString} ${pk.javaName}<#if pk.javaDefaultValue?has_content> = ${pk.javaDefaultValue}</#if>;
</#list>

<#if !config.pui9Version.withLombok>
	@PuiGenerated
	public ${config.selectedTable.javaName}Pk() {
	}

	<#assign params = "">
	<#list config.selectedTable.primaryKeys as pk>
		<#assign params += pk.javaTypeString + " "+ pk.javaName>
		<#if pk?has_next>
			<#assign params += ", ">
		</#if>
	</#list>

	@PuiGenerated
	public ${config.selectedTable.javaName}Pk(${params}) {
	<#list config.selectedTable.primaryKeys as pk>
		this.${pk.javaName} = ${pk.javaName};
	</#list>
	}

	<#list config.selectedTable.primaryKeys as pk>
	@PuiGenerated
	@Override
	public ${pk.javaTypeString} get${pk.javaName?cap_first}() {
		return ${pk.javaName};
	}

	@PuiGenerated
	@Override
	public void set${pk.javaName?cap_first}(${pk.javaTypeString} ${pk.javaName}) {
		this.${pk.javaName} = ${pk.javaName};
	}
	</#list>
</#if>

	@PuiGenerated
	@Override
	@SuppressWarnings("unchecked")
	public ${config.selectedTable.javaName}Pk createPk() {
		${config.selectedTable.javaName}Pk pk = <#if config.pui9Version.withLombok>pkBuilder().build()<#else>new ${config.selectedTable.javaName}Pk()</#if>;
		PuiObjectUtils.copyProperties(pk, this);
		return pk;
	}
}
</#compress>
