/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.codegen.pui9.db;

import es.prodevelop.codegen.pui9.enums.EntityTypeEnum;
import es.prodevelop.codegen.pui9.model.Column;
import es.prodevelop.codegen.pui9.model.ColumnVisibility;
import es.prodevelop.codegen.pui9.model.DatabaseColumnType;
import es.prodevelop.codegen.pui9.model.DatabaseType;
import es.prodevelop.codegen.pui9.model.Entity;
import es.prodevelop.codegen.pui9.model.GeometryType;
import es.prodevelop.codegen.pui9.model.Table;
import es.prodevelop.codegen.pui9.model.View;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CodegenModelsDatabaseUtils {
    private static CodegenModelsDatabaseUtils singleton;
    private Connection conn;
    private DatabaseType dbType;

    public static CodegenModelsDatabaseUtils singleton(Connection conn) {
        singleton = new CodegenModelsDatabaseUtils(conn);
        return singleton;
    }

    public static CodegenModelsDatabaseUtils singleton() {
        if (singleton == null) {
            throw new IllegalStateException("You should call singleton method with Model on first call in order to create the conection");
        }
        return singleton;
    }

    private CodegenModelsDatabaseUtils(Connection conn) {
        this.conn = conn;
        try {
            this.dbType = DatabaseType.getByOfficialName(conn.getMetaData().getDatabaseProductName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean loadTable(Table table) {
        boolean exists = this.modifyRealTableName(table, EntityTypeEnum.TABLE);
        if (!exists) {
            return false;
        }
        this.loadColumns(table);
        this.loadPrimaryKeys(table);
        return true;
    }

    public boolean loadView(View view) {
        boolean exists = this.modifyRealTableName(view, EntityTypeEnum.VIEW);
        if (!exists) {
            return false;
        }
        this.loadColumns(view);
        return true;
    }

    private void loadColumns(Entity entity) {
        try (ResultSet rs = this.conn.getMetaData().getColumns(null, null, entity.getDbName(), "%");){
            ArrayList<String> columns = new ArrayList<String>();
            while (rs.next()) {
                Column column = new Column();
                column.setEntity(entity);
                column.setDbName(rs.getString(ColumnMetadataEnum.COLUMN_NAME.name()));
                column.setDbType(DatabaseColumnType.getByTypeId(rs.getInt(ColumnMetadataEnum.DATA_TYPE.name())));
                if (column.getDbType() == null) continue;
                column.setDbRawType(rs.getString(ColumnMetadataEnum.TYPE_NAME.name()));
                column.setDbDefaultValue(rs.getString(ColumnMetadataEnum.COLUMN_DEF.name()));
                column.setDbSize(rs.getInt(ColumnMetadataEnum.COLUMN_SIZE.name()));
                column.setDbDecimals(rs.getInt(ColumnMetadataEnum.DECIMAL_DIGITS.name()));
                column.setNullable(rs.getInt(ColumnMetadataEnum.NULLABLE.name()) == 1);
                column.setPosition(rs.getInt(ColumnMetadataEnum.ORDINAL_POSITION.name()) - 1);
                column.setPk(false);
                column.setColumnVisibility(ColumnVisibility.visible);
                if (column.getDbName().equalsIgnoreCase("lang")) {
                    column.setColumnVisibility(ColumnVisibility.completelyhidden);
                }
                column.setAutoincrementable(false);
                column.setGeometry(this.dbType.geometryColumnNames.stream().anyMatch(gcm -> column.getDbRawType().contains((CharSequence)gcm)));
                boolean isDbAutoinc = rs.getBoolean(ColumnMetadataEnum.IS_AUTOINCREMENT.name());
                switch (this.dbType) {
                    case ORACLE: {
                        column.setGeometryType(GeometryType.NONE);
                        column.setSequence(isDbAutoinc || column.getDbDefaultValue().toLowerCase().contains("nextval"));
                        break;
                    }
                    case POSTGRE_SQL: {
                        if (column.getDbType().equals((Object)DatabaseColumnType.TIMESTAMP) && column.getDbDecimals() == 3) {
                            column.setDbType(DatabaseColumnType.TIMESTAMP_LOCAL_TIMEZONE);
                        }
                        if (column.isGeometry()) {
                            column.setGeometryType(this.lookForGeometryTypePostgresql(entity.getDbName(), column.getDbName()));
                        } else {
                            column.setGeometryType(GeometryType.NONE);
                        }
                        column.setSequence(isDbAutoinc || column.getDbRawType().toLowerCase().contains("serial"));
                        break;
                    }
                    case SQL_SERVER: {
                        if (column.getDbType().equals((Object)DatabaseColumnType.TIMESTAMP)) {
                            if (column.getDbDecimals() == 3) {
                                column.setDbType(DatabaseColumnType.TIMESTAMP_LOCAL_TIMEZONE);
                            } else {
                                column.setDbType(DatabaseColumnType.DATE);
                            }
                        }
                        column.setGeometryType(GeometryType.NONE);
                        column.setSequence(isDbAutoinc || column.getDbRawType().toLowerCase().contains("identity"));
                    }
                }
                entity.addColumn(column);
                columns.add(column.getDbName());
            }
            entity.removeWrongColumns(columns);
            entity.reorderColumns();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private GeometryType lookForGeometryTypePostgresql(String table, String column) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadPrimaryKeys(Table table) {
        try (ResultSet rs = this.conn.getMetaData().getPrimaryKeys(null, null, table.getDbName());){
            while (rs.next()) {
                table.addPrimaryKeyName(rs.getString(ColumnMetadataEnum.COLUMN_NAME.name()));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private boolean modifyRealTableName(Entity entity, EntityTypeEnum entityType) {
        if (this.existsTable(entity.getDbName(), entityType)) {
            return true;
        }
        if (this.existsTable(entity.getDbName().toLowerCase(), entityType)) {
            entity.setDbName(entity.getDbName().toLowerCase());
            return true;
        }
        if (this.existsTable(entity.getDbName().toUpperCase(), entityType)) {
            entity.setDbName(entity.getDbName().toUpperCase());
            return true;
        }
        return false;
    }

    private boolean existsTable(String entityName, EntityTypeEnum entityType) {
        boolean bl;
        block8: {
            ResultSet rs = this.conn.getMetaData().getTables(null, null, entityName, new String[]{entityType.name()});
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }

    private static enum ColumnMetadataEnum {
        COLUMN_NAME,
        DATA_TYPE,
        COLUMN_SIZE,
        TYPE_NAME,
        DECIMAL_DIGITS,
        COLUMN_DEF,
        NULLABLE,
        ORDINAL_POSITION,
        IS_AUTOINCREMENT;

    }
}

