/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.codegen.pui9.utils;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CodegenUtils {
    public static String getJavaName(String dbName) {
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            return dbName;
        }
        String specialChars = CodegenUtils.getSpecialChars(dbName);
        String regexDelimiters = CodegenUtils.getRegexDelimiters(specialChars);
        StringBuilder sbJava = new StringBuilder();
        if (!regexDelimiters.isEmpty()) {
            List<String> splits = Arrays.asList(dbName.split(regexDelimiters));
            Iterator<String> it = splits.iterator();
            while (it.hasNext()) {
                sbJava.append(StringUtils.capitalize((String)it.next().toLowerCase()));
            }
        } else {
            sbJava.append(StringUtils.capitalize((String)dbName.toLowerCase()));
        }
        return sbJava.toString().replaceAll("^[0-9]+", "");
    }

    private static String getSpecialChars(String name) {
        return Normalizer.normalize(name, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[a-zA-Z0-9]+", "");
    }

    private static String getRegexDelimiters(String specialChars) {
        StringBuilder sbSplits = new StringBuilder();
        for (int i = 0; i < specialChars.toCharArray().length; ++i) {
            char c = specialChars.charAt(i);
            sbSplits.append("\\" + c);
            if (i == specialChars.toCharArray().length - 1) continue;
            sbSplits.append("|");
        }
        return sbSplits.toString();
    }

    public static String convertColumnNameToJavaName(String dbName) {
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            return dbName;
        }
        return dbName.replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[^a-zA-Z0-9]+", "").toLowerCase();
    }

    private CodegenUtils() {
    }
}

