/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.codegen.pui9.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum DatabaseType {
    ORACLE("Oracle", "oracle", "Oracle", Arrays.asList("sdo_geometry", "st_geometry"), 1521),
    SQL_SERVER("SQL Server", "sqlserver", "Microsoft SQL Server", Collections.singletonList("geometry"), 1433),
    POSTGRE_SQL("Postgre SQL", "postgresql", "PostgreSQL", Collections.singletonList("geometry"), 5432);

    public final String dbName;
    public final String innerName;
    public final String officialName;
    private final List<String> geometryColumnNames;
    public final int defaultPort;

    private DatabaseType(String name, String innerName, String officialName, List<String> geometryColumnNames, int defaultPort) {
        this.dbName = name;
        this.innerName = innerName;
        this.officialName = officialName;
        this.geometryColumnNames = geometryColumnNames;
        this.defaultPort = defaultPort;
    }

    public List<String> getGeometryColumnNames() {
        return this.geometryColumnNames;
    }

    public static DatabaseType getByName(String name) {
        for (DatabaseType dte : DatabaseType.values()) {
            if (!dte.dbName.equals(name)) continue;
            return dte;
        }
        return null;
    }

    public static DatabaseType getByOfficialName(String officialName) {
        for (DatabaseType dte : DatabaseType.values()) {
            if (!dte.officialName.equals(officialName)) continue;
            return dte;
        }
        return null;
    }

    public static String[] getAllValues() {
        ArrayList<String> names = new ArrayList<String>();
        for (DatabaseType dte : DatabaseType.values()) {
            names.add(dte.dbName);
        }
        return names.toArray(new String[0]);
    }
}

