/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.spring.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import es.prodevelop.pui9.beans.IPuiInitDestroyBean;
import es.prodevelop.pui9.exceptions.PuiException;
import es.prodevelop.pui9.exceptions.PuiExceptionDto;
import es.prodevelop.pui9.messages.PuiMessagesRegistry;
import es.prodevelop.pui9.spring.configuration.annotations.PuiSpringConfiguration;
import es.prodevelop.pui9.utils.PuiDateUtil;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import es.prodevelop.pui9.utils.PuiObjectUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springdoc.core.customizers.OpenApiBuilderCustomizer;
import org.springdoc.core.customizers.ServerBaseUrlCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.AbstractSwaggerUiConfigProperties;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.SecurityService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.annotation.Scope;
import org.springframework.util.ObjectUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.pui9.PuiRequestMappingHandlerMapping;

@PuiSpringConfiguration
@PropertySources(value={@PropertySource(value={"classpath:openapi_config.properties"}), @PropertySource(value={"classpath:openapi.properties"}, ignoreResourceNotFound=true)})
@ComponentScan(value={"org.springdoc"})
@Import(value={PropertyPlaceholderAutoConfiguration.class})
public class PuiOpenapiSpringConfiguration
implements IPuiInitDestroyBean {
    public static final String AUTH_BEARER_JWT = "Bearer JWT";
    public static final String AUTH_USER_PASSWORD = "User-Password";
    public static final String AUTH_API_KEY = "Api-Key";
    @Value(value="${openapi.baseUrl:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).BASE_URL_DEFAULT}}")
    private String baseUrl;
    @Value(value="${openapi.title:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).INFO_TITLE_DEFAULT}}")
    private String infoTitle;
    @Value(value="${openapi.description:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).INFO_DESCRIPTION_DEFAULT}}")
    private String infoDescription;
    @Value(value="${openapi.version:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).INFO_VERSION_DEFAULT}}")
    private String infoVersion;
    @Value(value="${openapi.termsOfServiceUrl:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).INFO_TERMS_OF_SERVICE_URL_DEFAULT}}")
    private String infoTermsOfServiceUrl;
    @Value(value="${openapi.license:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).INFO_LICENSE_DEFAULT}}")
    private String license;
    @Value(value="${openapi.licenseUrl:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).INFO_LICENSE_URL_DEFAULT}}")
    private String licenseUrl;
    @Value(value="${openapi.contact.name:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).CONTACT_NAME_DEFAULT}}")
    private String contactName;
    @Value(value="${openapi.contact.email:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).CONTACT_EMAIL_DEFAULT}}")
    private String contactEmail;
    @Value(value="${openapi.contact.url:#{T(es.prodevelop.pui9.openapi.utils.PuiOpenapiConstants).CONTACT_URL_DEFAULT}}")
    private String contactUrl;
    @Value(value="${pui9.version}")
    private String pui9Version;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private PuiRequestMappingHandlerMapping requestMapping;
    private CustomizerCache customizerCache;

    public void afterPropertiesSet() throws Exception {
        Json.mapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    @Bean
    @Primary
    @Lazy(value=false)
    @Scope(scopeName="prototype")
    OpenAPIService openAPIBuilder(Optional<OpenAPI> openAPI, SecurityService securityParser, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils, Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomisers, Optional<List<ServerBaseUrlCustomizer>> serverBaseUrlCustomisers, Optional<JavadocProvider> javadocProvider) {
        return new OpenAPIService(openAPI, securityParser, springDocConfigProperties, propertyResolverUtils, openApiBuilderCustomisers, serverBaseUrlCustomisers, javadocProvider);
    }

    @Bean
    SwaggerUiConfigProperties swaggerUiConfigProperties(List<GroupedOpenApi> groups) {
        SwaggerUiConfigProperties props = new SwaggerUiConfigProperties();
        props.setDisplayRequestDuration(Boolean.valueOf(true));
        props.setDocExpansion("none");
        props.setDefaultModelExpandDepth(Integer.valueOf(0));
        props.setDefaultModelsExpandDepth(Integer.valueOf(0));
        props.setDisableSwaggerDefaultUrl(true);
        props.setEnabled(true);
        props.setPath("/swagger-ui.html");
        props.setVersion(SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion());
        props.setOperationsSorter("alpha");
        props.setTagsSorter("alpha");
        props.setOauth2RedirectUrl(null);
        AtomicReference<String> url = new AtomicReference<String>(this.servletContext.getContextPath());
        if (!ObjectUtils.isEmpty((Object)this.baseUrl)) {
            url.set(this.baseUrl);
        }
        props.setConfigUrl(url.get() + "/api-docs/swagger-config");
        props.setUrls(groups.stream().map(group -> {
            AbstractSwaggerUiConfigProperties.SwaggerUrl swaggerUrl = new AbstractSwaggerUiConfigProperties.SwaggerUrl();
            swaggerUrl.setName(group.getGroup());
            swaggerUrl.setUrl((String)url.get() + "/api-docs/" + group.getGroup());
            return swaggerUrl;
        }).collect(Collectors.toSet()));
        return props;
    }

    @Bean
    GroupedOpenApi pui9OpenApiGroup() {
        return GroupedOpenApi.builder().group("PUI9").addOpenApiCustomizer(openApi -> {
            this.commonOpenApiCustomizer(openApi);
            openApi.getInfo().setTitle(openApi.getInfo().getTitle() + " (Framework API)");
            openApi.getInfo().setDescription(openApi.getInfo().getDescription() + " (Framework API)");
            openApi.getInfo().setVersion(this.pui9Version);
        }).packagesToScan(new String[]{"es.prodevelop.pui9"}).pathsToMatch(new String[]{"/**"}).build();
    }

    @Bean
    GroupedOpenApi appOpenApiGroup() {
        return GroupedOpenApi.builder().group(this.infoTitle.replace(" ", "-")).addOpenApiCustomizer(openApi -> {
            this.commonOpenApiCustomizer(openApi);
            openApi.getInfo().setTitle(this.infoTitle);
            openApi.getInfo().setVersion(this.infoVersion);
        }).packagesToScan(new String[]{"es.prodevelop"}).packagesToExclude(new String[]{"es.prodevelop.pui9"}).pathsToMatch(new String[]{"/**"}).build();
    }

    public void commonOpenApiCustomizer(OpenAPI openApi) {
        this.setServer(openApi);
        this.addDefaultComponents(openApi);
        this.setInfo(openApi);
        if (!ObjectUtils.isEmpty(this.getCustomizerCache().securedPredicates)) {
            openApi.getComponents().addSecuritySchemes(AUTH_API_KEY, this.securitySchemeApiKey());
            openApi.getComponents().addSecuritySchemes(AUTH_USER_PASSWORD, this.securitySchemeBasic());
            openApi.getComponents().addSecuritySchemes(AUTH_BEARER_JWT, this.securitySchemeBearer());
        }
        Parameter timezoneParameter = new Parameter().$ref("Timezone");
        Parameter sourceParameter = new Parameter().$ref("Source");
        openApi.getPaths().forEach((path, item) -> item.readOperations().forEach(operation -> {
            operation.addParametersItem(timezoneParameter);
            operation.addParametersItem(sourceParameter);
            if (this.getCustomizerCache().securedPredicates.contains(path)) {
                operation.addSecurityItem(new SecurityRequirement().addList(AUTH_API_KEY));
                operation.addSecurityItem(new SecurityRequirement().addList(AUTH_USER_PASSWORD));
                operation.addSecurityItem(new SecurityRequirement().addList(AUTH_BEARER_JWT));
            }
            this.buildExceptions(openApi, (String)path, (Operation)operation);
        }));
    }

    private void setServer(OpenAPI openApi) {
        String url = this.servletContext.getContextPath();
        if (!ObjectUtils.isEmpty((Object)this.baseUrl)) {
            url = this.baseUrl;
        }
        Server server = new Server().url(url).description("Default server");
        openApi.servers(Collections.singletonList(server));
    }

    private void addDefaultComponents(OpenAPI openApi) {
        openApi.getComponents().addParameters("Timezone", this.timezoneParameter());
        openApi.getComponents().addParameters("Source", this.sourceParameter());
        openApi.getComponents().addSchemas("class", this.fakeClassSchema());
    }

    private Parameter timezoneParameter() {
        ArrayList<String> timezoneList = new ArrayList<String>();
        timezoneList.add(PuiDateUtil.utcZone.getId());
        return new Parameter().in("header").schema((Schema)new StringSchema()._enum(timezoneList)._default((String)timezoneList.iterator().next())).name("Timezone").allowEmptyValue(Boolean.valueOf(false)).required(Boolean.valueOf(true)).style(Parameter.StyleEnum.SIMPLE);
    }

    private Parameter sourceParameter() {
        ArrayList<String> sourceList = new ArrayList<String>();
        sourceList.add("openapi");
        return new Parameter().in("header").schema((Schema)new StringSchema()._enum(sourceList)._default((String)sourceList.iterator().next())).name("Source").allowEmptyValue(Boolean.valueOf(false)).required(Boolean.valueOf(true)).style(Parameter.StyleEnum.SIMPLE);
    }

    private Schema<?> fakeClassSchema() {
        return new StringSchema();
    }

    private SecurityScheme securitySchemeApiKey() {
        return new SecurityScheme().type(SecurityScheme.Type.APIKEY).name("X-API-Key").in(SecurityScheme.In.HEADER);
    }

    private SecurityScheme securitySchemeBasic() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic");
    }

    private SecurityScheme securitySchemeBearer() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT");
    }

    private void setInfo(OpenAPI openApi) {
        openApi.info(new Info().title(this.infoTitle).description(this.infoDescription).version(null).termsOfService(this.infoTermsOfServiceUrl).contact(this.contact()).license(this.license()));
    }

    private Contact contact() {
        return new Contact().name(this.contactName).url(this.contactUrl).email(this.contactEmail);
    }

    private License license() {
        return new License().name(this.license).url(this.licenseUrl);
    }

    private void buildExceptions(OpenAPI openApi, String path, Operation operation) {
        HandlerMethod hm = this.getCustomizerCache().pathMethodMap.get(path);
        if (hm == null) {
            return;
        }
        LinkedHashMap exceptionDtoProperties = new LinkedHashMap();
        PuiObjectUtils.getFields(PuiExceptionDto.class).forEach((name, field) -> {
            Schema propSchema = new Schema().type(field.getType().getSimpleName().toLowerCase());
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            if (field.getType().equals(Instant.class)) {
                propSchema.type(String.class.getSimpleName().toLowerCase()).format("date-time");
            }
            exceptionDtoProperties.put(name, propSchema);
        });
        for (Class<?> exClass : hm.getMethod().getExceptionTypes()) {
            Object code;
            if (!this.getCustomizerCache().exceptionsMap.containsKey(exClass)) {
                PuiException ex;
                code = -1;
                try {
                    Field codeField = exClass.getDeclaredField("CODE");
                    code = (Integer)codeField.get(exClass);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    code = PuiException.DEFAULT_INTERNAL_CODE;
                }
                String description = PuiMessagesRegistry.getSingleton().getString(PuiLanguageUtils.getDefaultLanguage(), ((Integer)code).toString());
                try {
                    Constructor<?> constructor = exClass.getConstructors()[0];
                    Object[] params = new Object[constructor.getParameterTypes().length];
                    ex = (PuiException)constructor.newInstance(params);
                }
                catch (Exception e) {
                    continue;
                }
                PuiExceptionDto exDto = ex.asTransferObject();
                exDto.withClassName(exClass.getSimpleName());
                exDto.withDetailedMessage("Detailed message, if applies");
                exDto.withErrorClassName("Class name where the error was thrown");
                exDto.withUrl(path);
                exDto.withMessage(description != null ? description : ex.getMessage());
                exDto.withInternalCode(((Integer)code).intValue());
                ApiResponse ar = new ApiResponse().description(description).content(new Content().addMediaType("application/json", new MediaType().schema(new ObjectSchema().example((Object)exDto).properties(exceptionDtoProperties))));
                ImmutablePair pair = new ImmutablePair((Object)(exDto.getStatusCode() + " (" + ((Integer)code).toString() + ")"), (Object)ar);
                this.getCustomizerCache().exceptionsMap.put(exClass, (Pair<String, ApiResponse>)pair);
                openApi.getComponents().addResponses((String)pair.getKey(), ar);
            }
            if (ObjectUtils.isEmpty((Object)(code = (String)this.getCustomizerCache().exceptionsMap.get(exClass).getKey()))) continue;
            operation.getResponses().addApiResponse((String)code, new ApiResponse().$ref((String)code));
        }
    }

    private CustomizerCache getCustomizerCache() {
        if (this.customizerCache == null) {
            this.customizerCache = new CustomizerCache();
        }
        return this.customizerCache;
    }

    private class CustomizerCache {
        Map<String, HandlerMethod> pathMethodMap = new LinkedHashMap<String, HandlerMethod>();
        Map<Class<?>, Pair<String, ApiResponse>> exceptionsMap = new LinkedHashMap();
        Set<String> securedPredicates = new LinkedHashSet<String>();

        CustomizerCache() {
            PuiOpenapiSpringConfiguration.this.requestMapping.getHandlerMethods().forEach((info, handlerMethod) -> {
                String path = (String)info.getPatternValues().iterator().next();
                this.pathMethodMap.put(path, (HandlerMethod)handlerMethod);
                if (PuiOpenapiSpringConfiguration.this.requestMapping.isWebServiceSessionRequired(handlerMethod)) {
                    this.securedPredicates.add(path);
                }
            });
        }
    }
}

