/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.spring.configuration;

import es.prodevelop.pui9.exceptions.PuiException;
import es.prodevelop.pui9.exceptions.PuiExceptionDto;
import es.prodevelop.pui9.messages.PuiMessagesRegistry;
import es.prodevelop.pui9.mvc.configuration.PuiMappingsInfo;
import es.prodevelop.pui9.openapi.properties.PuiOpenapiProperties;
import es.prodevelop.pui9.properties.PuiBaseSpringProperties;
import es.prodevelop.pui9.properties.PuiSpringProperties;
import es.prodevelop.pui9.spring.configuration.annotations.PuiSpringConfiguration;
import es.prodevelop.pui9.utils.PuiDateUtil;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import es.prodevelop.pui9.utils.PuiObjectUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ObjectUtils;
import org.springframework.web.method.HandlerMethod;

@PuiSpringConfiguration
public class PuiOpenapiSpringConfiguration {
    public static final String AUTH_BEARER_JWT = "Bearer JWT";
    public static final String AUTH_USER_PASSWORD = "User-Password";
    public static final String AUTH_API_KEY = "Api-Key";
    @Autowired
    private PuiBaseSpringProperties baseProperties;
    @Autowired
    private PuiSpringProperties springProperties;
    @Autowired
    private PuiOpenapiProperties openapiProperties;
    @Autowired
    private ServletContext servletContext;
    private Map<Class<?>, Pair<String, ApiResponse>> exceptionsMap = new LinkedHashMap();
    private Parameter timezoneParameter = new Parameter().$ref("Timezone");
    private Parameter sourceParameter = new Parameter().$ref("Source");

    @Bean
    public GlobalOpenApiCustomizer commonOpenApiCustomizer() {
        return this::commonOpenApiCustomizer;
    }

    @Bean
    GroupedOpenApi apiGroupPui9() {
        return GroupedOpenApi.builder().group("PUI9").addOpenApiCustomizer(openApi -> {
            openApi.getInfo().setTitle(openApi.getInfo().getTitle() + " (Framework API)");
            openApi.getInfo().setDescription(openApi.getInfo().getDescription() + " (Framework API)");
            openApi.getInfo().setVersion(this.baseProperties.getVersion());
        }).packagesToScan(new String[]{"es.prodevelop.pui9"}).pathsToMatch(new String[]{"/**"}).build();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.annotation.Endpoint"})
    GroupedOpenApi apiGroupActuators() {
        return GroupedOpenApi.builder().group("SPRING_BOOT_ACTUATORS").addOpenApiCustomizer(openApi -> {
            openApi.getInfo().setTitle(openApi.getInfo().getTitle() + " (Spring Boot Actuators)");
            openApi.getInfo().setDescription(openApi.getInfo().getDescription() + " (Spring Boot Actuators API)");
            openApi.getInfo().setVersion(SpringBootVersion.getVersion());
        }).packagesToScan(new String[]{"org.springframework.boot.actuate"}).pathsToMatch(new String[]{"/**"}).build();
    }

    private void commonOpenApiCustomizer(OpenAPI openApi) {
        this.setServer(openApi);
        this.addDefaultComponents(openApi);
        this.setInfo(openApi);
        if (!ObjectUtils.isEmpty((Object)PuiMappingsInfo.getSecuredPaths())) {
            openApi.getComponents().addSecuritySchemes(AUTH_API_KEY, this.securitySchemeApiKey());
            openApi.getComponents().addSecuritySchemes(AUTH_USER_PASSWORD, this.securitySchemeBasic());
            openApi.getComponents().addSecuritySchemes(AUTH_BEARER_JWT, this.securitySchemeBearer());
        }
        openApi.getPaths().forEach((path, item) -> item.readOperations().forEach(operation -> {
            operation.addParametersItem(this.timezoneParameter);
            operation.addParametersItem(this.sourceParameter);
            if (PuiMappingsInfo.getSecuredPaths().contains(path)) {
                operation.addSecurityItem(new SecurityRequirement().addList(AUTH_API_KEY));
                operation.addSecurityItem(new SecurityRequirement().addList(AUTH_USER_PASSWORD));
                operation.addSecurityItem(new SecurityRequirement().addList(AUTH_BEARER_JWT));
            }
            this.buildExceptions(openApi, (String)path, (Operation)operation);
        }));
    }

    private void setServer(OpenAPI openApi) {
        String url = this.servletContext.getContextPath();
        if (!ObjectUtils.isEmpty((Object)this.openapiProperties.getBaseUrl())) {
            url = this.openapiProperties.getBaseUrl();
        }
        Server server = new Server().url(url).description("Default server");
        openApi.servers(Collections.singletonList(server));
    }

    private void addDefaultComponents(OpenAPI openApi) {
        openApi.getComponents().addParameters("Timezone", this.timezoneParameter());
        openApi.getComponents().addParameters("Source", this.sourceParameter());
        openApi.getComponents().addSchemas("class", this.fakeClassSchema());
    }

    private Parameter timezoneParameter() {
        ArrayList<String> timezoneList = new ArrayList<String>();
        timezoneList.add(PuiDateUtil.utcZone.getId());
        return new Parameter().in("header").schema((Schema)new StringSchema()._enum(timezoneList)._default((String)timezoneList.iterator().next())).name("Timezone").allowEmptyValue(Boolean.valueOf(false)).required(Boolean.valueOf(true)).style(Parameter.StyleEnum.SIMPLE);
    }

    private Parameter sourceParameter() {
        ArrayList<String> sourceList = new ArrayList<String>();
        sourceList.add("openapi");
        return new Parameter().in("header").schema((Schema)new StringSchema()._enum(sourceList)._default((String)sourceList.iterator().next())).name("Source").allowEmptyValue(Boolean.valueOf(false)).required(Boolean.valueOf(true)).style(Parameter.StyleEnum.SIMPLE);
    }

    private Schema<?> fakeClassSchema() {
        return new StringSchema();
    }

    private SecurityScheme securitySchemeApiKey() {
        return new SecurityScheme().type(SecurityScheme.Type.APIKEY).name("X-API-Key").in(SecurityScheme.In.HEADER);
    }

    private SecurityScheme securitySchemeBasic() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic");
    }

    private SecurityScheme securitySchemeBearer() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT");
    }

    private void setInfo(OpenAPI openApi) {
        openApi.info(new Info().title(this.openapiProperties.getTitle()).description(this.openapiProperties.getDescription()).version(this.springProperties.getApplication().getVersion()).termsOfService(this.openapiProperties.getTermsOfServiceUrl()).contact(this.contact()).license(this.license()));
    }

    private Contact contact() {
        return new Contact().name(this.openapiProperties.getContact().getName()).url(this.openapiProperties.getContact().getUrl()).email(this.openapiProperties.getContact().getEmail());
    }

    private License license() {
        return new License().name(this.openapiProperties.getLicense().getName()).url(this.openapiProperties.getLicense().getUrl());
    }

    private void buildExceptions(OpenAPI openApi, String path, Operation operation) {
        HandlerMethod hm = PuiMappingsInfo.getPathMethod((String)path);
        if (hm == null) {
            return;
        }
        LinkedHashMap exceptionDtoProperties = new LinkedHashMap();
        PuiObjectUtils.getFields(PuiExceptionDto.class).forEach((name, field) -> {
            Schema propSchema = new Schema().type(field.getType().getSimpleName().toLowerCase());
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            if (field.getType().equals(Instant.class)) {
                propSchema.type(String.class.getSimpleName().toLowerCase()).format("date-time");
            }
            exceptionDtoProperties.put(name, propSchema);
        });
        for (Class<?> exClass : hm.getMethod().getExceptionTypes()) {
            Object code;
            if (!this.exceptionsMap.containsKey(exClass)) {
                PuiException ex;
                code = -1;
                try {
                    Field codeField = exClass.getDeclaredField("CODE");
                    code = (Integer)codeField.get(exClass);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    code = PuiException.DEFAULT_INTERNAL_CODE;
                }
                String description = PuiMessagesRegistry.getSingleton().getString(PuiLanguageUtils.getDefaultLanguage(), ((Integer)code).toString());
                try {
                    Constructor<?> constructor = exClass.getConstructors()[0];
                    Object[] params = new Object[constructor.getParameterTypes().length];
                    ex = (PuiException)constructor.newInstance(params);
                }
                catch (Exception e) {
                    continue;
                }
                PuiExceptionDto exDto = ex.asTransferObject();
                exDto.withClassName(exClass.getSimpleName());
                exDto.withDetailedMessage("Detailed message, if applies");
                exDto.withErrorClassName("Class name where the error was thrown");
                exDto.withUrl(path);
                exDto.withMessage(description != null ? description : ex.getMessage());
                exDto.withInternalCode(((Integer)code).intValue());
                ApiResponse ar = new ApiResponse().description(description).content(new Content().addMediaType("application/json", new MediaType().schema(new ObjectSchema().example((Object)exDto).properties(exceptionDtoProperties))));
                ImmutablePair pair = new ImmutablePair((Object)(exDto.getStatusCode() + " (" + ((Integer)code).toString() + ")"), (Object)ar);
                this.exceptionsMap.put(exClass, (Pair<String, ApiResponse>)pair);
                openApi.getComponents().addResponses((String)pair.getKey(), ar);
            }
            if (ObjectUtils.isEmpty((Object)(code = (String)this.exceptionsMap.get(exClass).getKey()))) continue;
            operation.getResponses().addApiResponse((String)code, new ApiResponse().$ref((String)code));
        }
    }
}

