/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script;

import java.time.Duration;
import java.time.Instant;

public class Step
implements AutoCloseable {
    public static final String NESTING_INDENT = "--->";
    public static final boolean DEBUG_ENABLED = System.getenv().containsKey("EVOLVER_SCRIPT_DEBUG_ENABLED");
    private static Step head;
    private final Step parent;
    private final String name;
    private final Instant start;
    private final int nestingLevel;
    private String skipReason = null;

    private Step(Step parent, String name) {
        this.parent = parent;
        this.name = name;
        this.start = Instant.now();
        int n = this.nestingLevel = parent != null ? parent.nestingLevel + 1 : 0;
        if (DEBUG_ENABLED) {
            this.printIndented("START %-58s%n", name);
        } else if (parent == null) {
            System.out.printf("%-58s", name);
        }
    }

    public static Step start(String name) {
        head = new Step(head, name);
        return head;
    }

    @Override
    public void close() {
        head = this.parent;
        if (DEBUG_ENABLED) {
            if (this.skipReason != null) {
                this.printIndented("[SKIPPED: %s]%n", this.skipReason);
            }
        } else if (this.parent == null) {
            if (this.skipReason != null) {
                System.out.printf("SKIPPED: %s%n", this.skipReason);
            } else {
                System.out.printf("DONE in %s%n", this.formatDuration(Duration.between(this.start, Instant.now())));
            }
        }
    }

    private String formatDuration(Duration dur) {
        long seconds = dur.toSeconds();
        if (seconds < 60L) {
            return "%d seconds".formatted(seconds);
        }
        return "%d min %d seconds".formatted(seconds / 60L, seconds % 60L);
    }

    public void skip(String skipReason) {
        this.skipReason = skipReason;
    }

    public void fail(String reason, Throwable cause) {
        if (DEBUG_ENABLED) {
            this.printIndented("FAILED %-58s%n", this.name);
            this.printIndented(" - %s%n", reason);
        } else {
            System.out.printf("FAILED %n%s%n", reason);
        }
        throw new RuntimeException(cause);
    }

    public void fail(String reason) {
        this.fail(reason, new IllegalStateException());
    }

    public void fail(Throwable cause) {
        this.fail("\u2013", cause);
    }

    private void printIndented(String format, Object ... args) {
        System.err.print(NESTING_INDENT.repeat(this.nestingLevel));
        System.err.printf(format, args);
    }

    public void info(String text) {
        if (DEBUG_ENABLED) {
            this.printIndented("%s%n", text);
        }
    }
}

