/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Download;
import fi.evolver.script.FileUtil;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import fi.evolver.script.system.Architecture;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class AwsCli {
    public static void install() throws IOException {
        try (Step step = Step.start("AWS CLI: install");){
            if (Files.exists(Path.of("/usr/local/aws-cli", new String[0]), new LinkOption[0])) {
                step.skip("Already installed");
                return;
            }
            Apt.install("unzip");
            String url = switch (Architecture.validated()) {
                default -> throw new MatchException(null, null);
                case Architecture.AMD64 -> "https://awscli.amazonaws.com/awscli-exe-linux-x86_64.zip";
                case Architecture.ARM64 -> "https://awscli.amazonaws.com/awscli-exe-linux-aarch64.zip";
            };
            Path zipFile = Download.intoTempFile(url);
            Path tmpDir = FileUtil.createTempDir("awscli");
            Shell.user("unzip", "-o", zipFile.toString(), "-d", tmpDir.toString());
            Path installer = tmpDir.resolve("aws").resolve("install");
            Shell.sudo(installer.toString(), "--update");
            FileUtil.addShellBlock(Shell.BASHRC, "AWS CLI bash completion", "complete -C '/usr/local/bin/aws_completer' aws\n");
        }
    }

    public static void installSessionManagerPlugin() throws IOException {
        try (Step step = Step.start("AWS CLI: install session manager plugin");){
            if (Apt.isInstalled("session-manager-plugin")) {
                step.skip("Already installed");
                return;
            }
            Apt.installFromUrl(switch (Architecture.validated()) {
                default -> throw new MatchException(null, null);
                case Architecture.AMD64 -> "https://s3.amazonaws.com/session-manager-downloads/plugin/latest/ubuntu_64bit/session-manager-plugin.deb";
                case Architecture.ARM64 -> "https://s3.amazonaws.com/session-manager-downloads/plugin/latest/ubuntu_arm64/session-manager-plugin.deb";
            });
        }
    }
}

