/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.FileUtil;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class Chrome {
    private static final String EXTERNAL_EXTENSION_JSON = "{\n\t\"external_update_url\": \"https://clients2.google.com/service/update2/crx\"\n}\n";
    private static final Path CONFIG_DIR_CHROME = Shell.HOME.resolve(".config/google-chrome");
    private static final Path CONFIG_DIR_CHROMIUM = Shell.HOME.resolve(".config/chromium");
    public static final String EXTENSION_REACT_DEVELOPER_TOOLS = "fmkadmapgofadopljbjfkapdkoienihi";
    public static final String EXTENSION_REDUX_DEV_TOOLS = "lmhkpmbekcpmknklioeibfkpmmfibljd";

    public static void addExtensions(Flavor flavor, List<String> extensionIds) throws IOException {
        try (Step step = Step.start("%s: Add extensions".formatted(flavor.label));){
            Path externalExtensionsDir = Chrome.getConfigDir(flavor).resolve("External Extensions");
            if (Files.exists(externalExtensionsDir, new LinkOption[0])) {
                step.skip("External extensions already configured");
                return;
            }
            Files.createDirectories(externalExtensionsDir, new FileAttribute[0]);
            for (String extensionId : extensionIds) {
                Path extensionFile = externalExtensionsDir.resolve(extensionId + ".json");
                FileUtil.write(extensionFile, EXTERNAL_EXTENSION_JSON);
            }
        }
    }

    public static void installBookmarks(Flavor flavor, Path bookmarksSourcePath) throws IOException {
        try (Step step = Step.start("%s: Install Bookmarks".formatted(flavor.label));){
            Path defaultProfileDir = Chrome.getConfigDir(flavor).resolve("Default");
            Path targetFile = defaultProfileDir.resolve("Bookmarks");
            if (Files.exists(targetFile, new LinkOption[0])) {
                step.skip("Bookmarks already exist");
                return;
            }
            Files.createDirectories(defaultProfileDir, new FileAttribute[0]);
            Files.copy(bookmarksSourcePath, targetFile, new CopyOption[0]);
        }
    }

    private static Path getConfigDir(Flavor flavor) {
        return switch (flavor.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> CONFIG_DIR_CHROME;
            case 1 -> CONFIG_DIR_CHROMIUM;
        };
    }

    public static enum Flavor {
        CHROME("Chrome"),
        CHROMIUM("Chromium");

        private final String label;

        private Flavor(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

