/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public class Git {
    public static void install() {
        try (Step step = Step.start("Install git");){
            Apt.install("git");
        }
    }

    public static void configureUser(String name, String email) {
        try (Step step = Step.start("Git: Configure user");){
            if (name == null || name.isBlank()) {
                step.fail("Git user name is empty");
            }
            if (email == null || email.isBlank()) {
                step.fail("Git user email is empty");
            }
            Shell.user("git", "config", "--global", "user.name", name);
            Shell.user("git", "config", "--global", "user.email", email);
        }
    }

    public static void clone(String repository, Path target) {
        try (Step step = Step.start("Git clone %s".formatted(repository.replaceFirst(".*/", "").replaceFirst("\\.git$", "")));){
            Apt.ensureInstalled("git");
            if (target.toFile().exists()) {
                step.skip("Clone target already exists");
                return;
            }
            Shell.user("git", "clone", repository, target.toAbsolutePath().toString());
        }
    }

    public static void addAliases(Map<String, String> aliases) {
        try (Step step = Step.start("Git: Add aliases: " + String.valueOf(aliases.keySet()));){
            aliases.forEach((alias, definition) -> Shell.user("git", "config", "--global", "alias." + alias, definition));
        }
    }

    public static Optional<String> getUserName() {
        Shell.Result result = Shell.Command.user("git", "config", "--global", "user.name").failOnError(false).run();
        if (result.success()) {
            return Optional.of(result.stdout().trim());
        }
        return Optional.empty();
    }

    public static Optional<String> getEmail() {
        Shell.Result result = Shell.Command.user("git", "config", "--global", "user.email").failOnError(false).run();
        if (result.success()) {
            return Optional.of(result.stdout().trim());
        }
        return Optional.empty();
    }
}

