/*
 * Decompiled with CFR 0.152.
 */
package io.altadata;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONObject;

public class AltaData {
    static final String DATA_API_URL = "https://www.altadata.io/data/api/";
    static final String SUBSCRIPTION_API_URL = "https://www.altadata.io/subscription/api/subscriptions";
    private String api_key;
    private String data_request_url;
    private int limit;

    public String getApi_key() {
        return this.api_key;
    }

    public void setApi_key(String api_key) {
        this.api_key = api_key;
    }

    public String getData_request_url() {
        return this.data_request_url;
    }

    public void setData_request_url(String data_request_url) {
        this.data_request_url = data_request_url;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public AltaData(String api_key) {
        this.setApi_key(api_key);
    }

    public AltaData get_data(String product_code, Integer limit) throws Exception {
        this.setData_request_url(DATA_API_URL + product_code + "/?format=json&api_key=" + this.getApi_key());
        if (limit != null && limit < 1) {
            throw new Exception("limit parameter must be greater than 0");
        }
        int current_limit = limit == null ? -1 : limit;
        this.setLimit(current_limit);
        return this;
    }

    public AltaData get_data(String product_code) {
        this.setData_request_url(DATA_API_URL + product_code + "/?format=json&api_key=" + this.getApi_key());
        this.setLimit(-1);
        return this;
    }

    public ArrayList<JSONObject> load() throws IOException, InterruptedException {
        String response_json;
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        int page = 1;
        int total_size = 1;
        int limit = this.getLimit();
        while ((response_json = this.request(this.getData_request_url() + "&page=" + page)).contains("}")) {
            String[] arrayJson = response_json.split("},");
            for (int i = 0; i < arrayJson.length; ++i) {
                JSONObject jo;
                Object json_item;
                if (i != arrayJson.length - 1) {
                    json_item = arrayJson[i] + "}";
                    jo = new JSONObject((String)json_item);
                    data.add(jo);
                    continue;
                }
                json_item = arrayJson[i];
                jo = new JSONObject((String)json_item);
                data.add(jo);
            }
            if (limit != -1 && (total_size += arrayJson.length) > limit) break;
            ++page;
        }
        if (limit != -1) {
            ArrayList<JSONObject> limited_data = new ArrayList<JSONObject>();
            for (int i = 0; i < limit; ++i) {
                limited_data.add(data.get(i));
            }
            return limited_data;
        }
        return data;
    }

    public AltaData sort(String order_column, String order_method) throws Exception {
        if (order_method.equals("asc") || order_method.equals("desc")) {
            this.setData_request_url(this.getData_request_url() + "&order_by=" + order_column + "_" + order_method);
            return this;
        }
        throw new Exception("order_method parameter must be 'asc' or 'desc'");
    }

    public AltaData equal(String condition_column, String condition_value) {
        this.setData_request_url(this.getData_request_url() + "&" + condition_column + "_eq=" + condition_value);
        return this;
    }

    public AltaData not_equal(String condition_column, String condition_value) {
        this.setData_request_url(this.getData_request_url() + "&" + condition_column + "_neq=" + condition_value);
        return this;
    }

    public AltaData greater_than(String condition_column, String condition_value) {
        this.setData_request_url(this.getData_request_url() + "&" + condition_column + "_gt=" + condition_value);
        return this;
    }

    public AltaData greater_than_equal(String condition_column, String condition_value) {
        this.setData_request_url(this.getData_request_url() + "&" + condition_column + "_gte=" + condition_value);
        return this;
    }

    public AltaData less_than(String condition_column, String condition_value) {
        this.setData_request_url(this.getData_request_url() + "&" + condition_column + "_lt=" + condition_value);
        return this;
    }

    public AltaData less_than_equal(String condition_column, String condition_value) {
        this.setData_request_url(this.getData_request_url() + "&" + condition_column + "_lte=" + condition_value);
        return this;
    }

    public AltaData select(String[] selected_column) {
        String selected_column_text = String.join((CharSequence)",", selected_column);
        this.setData_request_url(this.getData_request_url() + "&columns=" + selected_column_text);
        return this;
    }

    public AltaData condition_in(String condition_column, String[] condition_value) {
        String condition_value_text = String.join((CharSequence)",", condition_value);
        this.setData_request_url(this.getData_request_url() + "&" + condition_column + "_in=" + condition_value_text);
        return this;
    }

    public AltaData condition_not_in(String condition_column, String[] condition_value) {
        String condition_value_text = String.join((CharSequence)",", condition_value);
        this.setData_request_url(this.getData_request_url() + "&" + condition_column + "_notin=" + condition_value_text);
        return this;
    }

    public ArrayList<JSONObject> list_subscription() throws IOException, InterruptedException {
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        String request_url = "https://www.altadata.io/subscription/api/subscriptions?api_key=" + this.getApi_key();
        String response_json = this.request(request_url);
        String[] arrayJson = response_json.split("},\\{");
        for (int i = 0; i < arrayJson.length; ++i) {
            JSONObject jo;
            String json_item;
            if (i == 0) {
                json_item = arrayJson[i] + "}";
                jo = new JSONObject(json_item);
                data.add(jo);
                continue;
            }
            if (i == arrayJson.length - 1) {
                json_item = "{" + arrayJson[i];
                jo = new JSONObject(json_item);
                data.add(jo);
                continue;
            }
            json_item = "{" + arrayJson[i] + "}";
            jo = new JSONObject(json_item);
            data.add(jo);
        }
        return data;
    }

    public Set<String> get_header(String product_code) throws IOException, InterruptedException {
        String request_url = DATA_API_URL + product_code + "/?format=json&api_key=" + this.getApi_key() + "&page=1";
        String response_json = this.request(request_url);
        String[] arrayJson = response_json.split("},");
        String json_item = arrayJson[0] + "}";
        JSONObject jo = new JSONObject(json_item);
        return jo.keySet();
    }

    private String request(String request_url) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().header("accept", "application/json").uri(URI.create(request_url)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        return response.body().replace("[", "").replace("]", "");
    }
}

