/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.defectdojo;

import io.codemodder.providers.defectdojo.Finding;
import io.codemodder.providers.defectdojo.RuleFindings;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class DefaultRuleFindings
implements RuleFindings {
    private final Map<Path, List<Finding>> findingsByPath;

    DefaultRuleFindings(List<Finding> findings, Path projectDir) {
        Objects.requireNonNull(findings);
        Objects.requireNonNull(projectDir);
        this.findingsByPath = findings.stream().collect(Collectors.groupingBy(f -> projectDir.resolve(f.getFilePath())));
    }

    @Override
    public List<Finding> getForPath(Path path) {
        return this.findingsByPath.getOrDefault(path, List.of());
    }

    @Override
    public boolean isEmpty() {
        return this.findingsByPath.isEmpty();
    }
}

