/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFSarifInput;
import io.codemodder.codetf.CodeTFValidator;
import java.util.List;
import java.util.Objects;

public final class CodeTFRun {
    private final String vendor;
    private final String tool;
    private final String version;
    private final String commandLine;
    private final Long elapsed;
    private final String directory;
    private final List<CodeTFSarifInput> sarifs;

    @JsonCreator
    public CodeTFRun(@JsonProperty(value="vendor") String vendor, @JsonProperty(value="tool") String tool, @JsonProperty(value="version") String version, @JsonProperty(value="commandLine") String commandLine, @JsonProperty(value="elapsed") Long elapsed, @JsonProperty(value="directory") String directory, @JsonProperty(value="sarifs") List<CodeTFSarifInput> sarifs) {
        this.vendor = CodeTFValidator.requireNonBlank(vendor);
        this.tool = CodeTFValidator.requireNonBlank(tool);
        this.version = CodeTFValidator.requireNonBlank(version);
        this.commandLine = Objects.requireNonNull(commandLine);
        if (elapsed <= 0L) {
            throw new IllegalArgumentException("elapsed must be a positive value");
        }
        this.elapsed = elapsed;
        this.directory = CodeTFValidator.requireNonBlank(directory);
        this.sarifs = CodeTFValidator.toImmutableCopyOrEmptyOnNull(sarifs);
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getTool() {
        return this.tool;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getElapsed() {
        return this.elapsed;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public List<CodeTFSarifInput> getSarifs() {
        return this.sarifs;
    }

    public String getDirectory() {
        return this.directory;
    }
}

