/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import io.codemodder.codetf.CodeTFReport;
import io.codemodder.codetf.CodeTFReportGenerator;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.codetf.CodeTFRun;
import io.codemodder.codetf.CodeTFSarifInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

final class DefaultCodeTFReportGenerator
implements CodeTFReportGenerator {
    DefaultCodeTFReportGenerator() {
    }

    @Override
    public CodeTFReport createReport(Path repositoryRoot, String commandLine, List<Path> sarifs, List<CodeTFResult> results, long elapsed) {
        List<CodeTFSarifInput> sarifInputs = sarifs.stream().map(sarif -> {
            try {
                return new CodeTFSarifInput(Files.readString(sarif), this.getSha1((Path)sarif));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        CodeTFRun run = new CodeTFRun("io.codemodder", "codemodder", "1.0.0", commandLine, elapsed, repositoryRoot.toString(), sarifInputs);
        return new CodeTFReport(run, results);
    }

    private String getSha1(Path file) {
        try {
            return DigestUtils.sha1Hex((InputStream)Files.newInputStream(file, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to sha1 sarif file", e);
        }
    }
}

