/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javalogger;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;

public class Logger {
    private static Logger instance;
    private File logFolder = new File(System.getenv("PROGRAMDATA") + File.separator + "JavaLogger");
    private File currentLogFile = new File(this.logFolder.getPath() + File.separator + Logger.getLogFileDate() + ".log");
    private boolean isDebug;
    private boolean isVerbose;
    private static final String RESET = "\u001b[0m";
    public static final String WHITE = "\u001b[37m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String RED = "\u001b[31m";
    private static String defaultVerboseColor;
    private static String defaultInfoColor;
    private static String defaultWarningColor;
    private static String defaultErrorColor;

    private Logger() {
    }

    public static Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public void setLogFolder(File logFolder) {
        this.logFolder = logFolder;
        this.currentLogFile = new File(logFolder.getPath() + File.separator + Logger.getLogFileDate() + ".log");
    }

    public void setDebug(boolean isDebugMode) {
        this.isDebug = isDebugMode;
    }

    public void setVerbose(boolean isVerboseMode) {
        this.isVerbose = isVerboseMode;
    }

    public void setDefaultColors(String verboseColor, String infoColor, String warningColor, String errorColor) {
        defaultVerboseColor = verboseColor == null ? defaultVerboseColor : verboseColor;
        defaultInfoColor = infoColor == null ? defaultInfoColor : infoColor;
        defaultWarningColor = warningColor == null ? defaultWarningColor : warningColor;
        defaultErrorColor = errorColor == null ? defaultErrorColor : errorColor;
    }

    public static void VERBOSE(String text) {
        LOG l = new LOG(text).COLOR(defaultVerboseColor).LEVEL(LEVEL.VER).CODE(0).EXCEPTION(null).FILE_ENTRY(false).DEBUG(false).VERBOSE(true);
        Logger.getInstance().log(l);
    }

    public static void INFO(String text) {
        LOG l = new LOG(text).COLOR(defaultInfoColor).LEVEL(LEVEL.INF).CODE(0).EXCEPTION(null).FILE_ENTRY(true).DEBUG(true).VERBOSE(true);
        Logger.getInstance().log(l);
    }

    public static void WARNING(String text) {
        LOG l = new LOG(text).COLOR(defaultWarningColor).LEVEL(LEVEL.WRN).CODE(0).EXCEPTION(null).FILE_ENTRY(true).DEBUG(false).VERBOSE(false);
        Logger.getInstance().log(l);
    }

    public static void ERROR(String text) {
        LOG l = new LOG(text).COLOR(defaultErrorColor).LEVEL(LEVEL.ERR).CODE(0).EXCEPTION(null).FILE_ENTRY(true).DEBUG(false).VERBOSE(false);
        Logger.getInstance().log(l);
    }

    public void log(LOG log) {
        if (log.onlyDebug && this.isDebug || log.onlyVerbose && this.isVerbose || !log.onlyVerbose && !log.onlyDebug) {
            String logOutput = Logger.createLogString(log);
            System.out.println(log.color + logOutput + RESET);
            if (log.fileEntry) {
                if (!this.currentLogFile.exists()) {
                    this.createLogFile();
                }
                try {
                    ArrayList<String> fileContent = new ArrayList<String>(Files.readAllLines(this.currentLogFile.toPath(), StandardCharsets.UTF_8));
                    fileContent.add(logOutput);
                    if (log.exception != null) {
                        fileContent.add("\t" + Arrays.toString(log.exception.getStackTrace()).replace(", ", "\n\t").replace("[", "").replace("]", ""));
                    }
                    Files.write(this.currentLogFile.toPath(), fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    System.out.println("\u001b[31mSomething went wrong when writing to the log-file\u001b[0m");
                }
            }
        }
    }

    private static String createLogString(LOG log) {
        String errorCode = log.errorCode == 0 ? "[---]" : "[" + log.errorCode + "]";
        String prefix = "[" + (Object)((Object)log.loglevel) + "]";
        return Logger.getLogEntryDate() + prefix + errorCode + log.message;
    }

    private static String getLogEntryDate() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        return "[" + dtf.format(now) + "]";
    }

    private static String getLogFileDate() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
        LocalDateTime now = LocalDateTime.now();
        return dtf.format(now);
    }

    private void createLogFile() {
        LOG l;
        try {
            Files.createDirectories(this.logFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            l = new LOG("Could not create log-directory: " + this.logFolder).COLOR(RED).LEVEL(LEVEL.ERR).CODE(0).EXCEPTION(e).FILE_ENTRY(false);
            this.log(l);
        }
        try {
            this.currentLogFile.createNewFile();
        }
        catch (IOException e) {
            l = new LOG("Could not create file: " + this.currentLogFile).COLOR(RED).LEVEL(LEVEL.ERR).CODE(0).EXCEPTION(e).FILE_ENTRY(false);
            this.log(l);
        }
    }

    static {
        defaultVerboseColor = WHITE;
        defaultInfoColor = WHITE;
        defaultWarningColor = YELLOW;
        defaultErrorColor = RED;
    }

    public static enum LEVEL {
        VER,
        INF,
        WRN,
        ERR;

    }

    public static class LOG {
        private final String message;
        private String color = "\u001b[0m";
        private LEVEL loglevel = LEVEL.INF;
        private int errorCode = 0;
        private Exception exception = null;
        private boolean fileEntry = true;
        private boolean onlyVerbose = false;
        private boolean onlyDebug = false;

        public LOG(String text) {
            this.message = text;
        }

        public LOG COLOR(String colorCode) {
            this.color = colorCode;
            return this;
        }

        public LOG LEVEL(LEVEL levelEnum) {
            this.loglevel = levelEnum;
            return this;
        }

        public LOG CODE(int exceptionCode) {
            this.errorCode = exceptionCode;
            return this;
        }

        public LOG EXCEPTION(Exception e) {
            this.exception = e;
            return this;
        }

        public LOG FILE_ENTRY(boolean shouldWriteToFile) {
            this.fileEntry = shouldWriteToFile;
            return this;
        }

        public LOG DEBUG(boolean onlyInDebugMode) {
            this.onlyDebug = onlyInDebugMode;
            return this;
        }

        public LOG VERBOSE(boolean onlyInVerboseMode) {
            this.onlyVerbose = onlyInVerboseMode;
            return this;
        }
    }
}

