/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javalogger;

import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelHandler {
    private static MessageBuilder builder;
    private static ClientDelivery delivery;
    private static String projectToken;
    private static String userID;
    private static final Map<String, String> defaultProperties;

    private MixpanelHandler() {
    }

    public static boolean sendMessages() {
        if (delivery == null) {
            return false;
        }
        try {
            new MixpanelAPI().deliver(delivery);
        }
        catch (IOException e) {
            return false;
        }
        delivery = null;
        return true;
    }

    public static boolean addMessage(String eventName, Map<String, String> properties) {
        if (eventName == null || userID == null || projectToken == null) {
            return false;
        }
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        properties.putAll(defaultProperties);
        JSONObject props = new JSONObject();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            try {
                props.put(property.getKey(), (Object)property.getValue());
            }
            catch (JSONException jSONException) {}
        }
        if (delivery == null) {
            delivery = new ClientDelivery();
        }
        delivery.addMessage(MixpanelHandler.getBuilder().event(userID, eventName, props));
        return true;
    }

    public static boolean addDefaultProperty(String propertyName, String propertyValue) {
        if (defaultProperties.containsKey(propertyName)) {
            return false;
        }
        defaultProperties.put(propertyName, propertyValue);
        return true;
    }

    public static void setProject(String mixpanelProjectToken) {
        projectToken = mixpanelProjectToken;
    }

    public static void setUniqueID(String distinctMixpanelID) {
        userID = distinctMixpanelID;
    }

    private static MessageBuilder getBuilder() {
        if (builder == null) {
            builder = new MessageBuilder(projectToken);
        }
        return builder;
    }

    static {
        projectToken = null;
        userID = null;
        defaultProperties = new HashMap<String, String>();
    }
}

