/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javalogger.logging;

import io.fi0x.javalogger.logging.LogTemplate;
import io.fi0x.javalogger.logging.Logger;

public class LogEntry {
    final String message;
    String color = "";
    String background = "";
    String loglevel = "INF";
    int errorCode = 0;
    Exception exception = null;
    boolean fileEntry = true;
    boolean onlyVerbose = false;
    int verboseLevel = 0;
    boolean onlyDebug = false;
    boolean plainText = false;
    boolean consoleException = false;
    boolean mixpanel = false;
    String mixpanelEventName = "LOG";

    public LogEntry(String text) {
        this.message = text;
    }

    public LogEntry(String text, String templateName) throws IllegalArgumentException {
        if (!Logger.templates.containsKey(templateName)) {
            throw new IllegalArgumentException("A LogTemplate with this name does not exist");
        }
        this.message = text;
        LogTemplate t = Logger.templates.get(templateName);
        this.color = t.color;
        this.background = t.background;
        this.loglevel = t.loglevel;
        this.fileEntry = t.fileEntry;
        this.onlyVerbose = t.onlyVerbose;
        this.verboseLevel = t.verboseLevel;
        this.onlyDebug = t.onlyDebug;
        this.plainText = t.plainText;
        this.consoleException = t.consoleException;
        this.mixpanel = t.mixpanelMessage;
        this.mixpanelEventName = t.mixpanelEventName;
    }

    public LogEntry(String text, Enum<?> templateName) throws IllegalArgumentException {
        this(text, templateName.name());
    }

    public LogEntry COLOR(String colorCode) {
        this.color = colorCode;
        return this;
    }

    public LogEntry BACKGROUND(String colorCode) {
        this.background = colorCode;
        return this;
    }

    public LogEntry LEVEL(String levelEnum) {
        this.loglevel = levelEnum;
        return this;
    }

    public LogEntry CODE(int exceptionCode) {
        this.errorCode = exceptionCode;
        return this;
    }

    public LogEntry EXCEPTION(Exception e) {
        this.exception = e;
        return this;
    }

    public LogEntry FILE_ENTRY(boolean shouldWriteToFile) {
        this.fileEntry = shouldWriteToFile;
        return this;
    }

    public LogEntry DEBUG(boolean onlyInDebugMode) {
        this.onlyDebug = onlyInDebugMode;
        return this;
    }

    public LogEntry VERBOSE(boolean onlyInVerboseMode) {
        this.onlyVerbose = onlyInVerboseMode;
        return this;
    }

    public LogEntry LEVEL(int verboseLvl) {
        this.verboseLevel = verboseLvl;
        return this;
    }

    public LogEntry PLAINTEXT(boolean onlyPlaintext) {
        this.plainText = onlyPlaintext;
        return this;
    }

    public LogEntry CONSOLE_EXCEPTIONS(boolean showExceptionsInConsole) {
        this.consoleException = showExceptionsInConsole;
        return this;
    }

    public LogEntry MIXPANEL(boolean sendToMixpanel) {
        this.mixpanel = sendToMixpanel;
        return this;
    }

    public LogEntry MIXPANELNAME(String mixpanelEvent) {
        this.mixpanelEventName = mixpanelEvent;
        return this;
    }
}

