/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javalogger.mixpanel;

import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import io.fi0x.javalogger.logging.LogEntry;
import io.fi0x.javalogger.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelHandler {
    private static Thread uploader = null;
    private static long updateDelay = 5000L;
    private static MessageBuilder builder;
    private static ClientDelivery delivery;
    private static String projectToken;
    private static String userID;
    private static final Map<String, String> defaultProperties;
    private static final ArrayList<String> MIXPANEL_PROPERTIES;

    private MixpanelHandler() {
    }

    public static boolean sendMessages() {
        if (delivery == null) {
            return false;
        }
        if (uploader != null) {
            uploader.interrupt();
        }
        return MixpanelHandler.sendDelivery() == null;
    }

    public static boolean addMessage(String eventName, Map<String, String> properties) {
        if (eventName == null || userID == null || projectToken == null) {
            LogEntry l = new LogEntry("Could not add Mixpanel-event to queue. Name, UserID or ProjectToken is null").COLOR("\u001b[0;31m").LEVEL("ERR").CODE(0).FILE_ENTRY(false);
            Logger.log(l);
            return false;
        }
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        for (String prop : properties.keySet()) {
            if (!MIXPANEL_PROPERTIES.contains(prop.toLowerCase(Locale.ROOT))) continue;
            LogEntry l = new LogEntry("Could not add Mixpanel-event to queue. Property '" + prop + "' is a property mixpanel uses itself").COLOR("\u001b[0;31m").LEVEL("ERR").CODE(0).FILE_ENTRY(false);
            Logger.log(l);
            return false;
        }
        properties.putAll(defaultProperties);
        JSONObject props = new JSONObject();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            try {
                props.put(property.getKey(), (Object)property.getValue());
            }
            catch (JSONException jSONException) {}
        }
        if (delivery == null) {
            delivery = new ClientDelivery();
        }
        delivery.addMessage(MixpanelHandler.getBuilder().event(userID, eventName, props));
        MixpanelHandler.startUploaderThread();
        return true;
    }

    public static boolean addDefaultProperty(String propertyName, String propertyValue) {
        if (defaultProperties.containsKey(propertyName)) {
            return false;
        }
        if (MIXPANEL_PROPERTIES.contains(propertyName.toLowerCase(Locale.ROOT))) {
            return false;
        }
        defaultProperties.put(propertyName, propertyValue);
        return true;
    }

    public static boolean setMilliDelay(long minMillisBetweenMessages) {
        if (minMillisBetweenMessages < 500L) {
            return false;
        }
        updateDelay = minMillisBetweenMessages;
        return true;
    }

    public static void setProjectToken(String mixpanelProjectToken) {
        projectToken = mixpanelProjectToken;
    }

    public static void setUniqueUserID(String distinctMixpanelID) {
        userID = distinctMixpanelID;
    }

    private static MessageBuilder getBuilder() {
        if (builder == null) {
            builder = new MessageBuilder(projectToken);
        }
        return builder;
    }

    private static void startUploaderThread() {
        if (uploader == null) {
            uploader = new Thread(() -> {
                try {
                    Thread.sleep(updateDelay);
                }
                catch (InterruptedException e) {
                    uploader = null;
                    return;
                }
                IOException e = MixpanelHandler.sendDelivery();
                if (e != null) {
                    LogEntry l = new LogEntry("Could not upload a Mixpanel delivery").COLOR("\u001b[0;31m").LEVEL("ERR").CODE(0).EXCEPTION(e).FILE_ENTRY(false);
                    Logger.log(l);
                }
                uploader = null;
            });
        }
        if (!uploader.isAlive()) {
            uploader.start();
        }
    }

    private static IOException sendDelivery() {
        try {
            new MixpanelAPI().deliver(delivery);
        }
        catch (IOException e) {
            return e;
        }
        delivery = null;
        return null;
    }

    static {
        projectToken = null;
        userID = null;
        defaultProperties = new HashMap<String, String>();
        MIXPANEL_PROPERTIES = new ArrayList<String>(){
            {
                this.add("api endpoint");
                this.add("api timestamp");
                this.add("distinct id");
                this.add("insert id");
                this.add("mixpanel library");
                this.add("time");
                this.add("time processed");
            }
        };
    }
}

