/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javalogger.logging;

import io.fi0x.javalogger.logging.LogEntry;
import io.fi0x.javalogger.logging.LogLevel;
import io.fi0x.javalogger.logging.LogTemplate;
import io.fi0x.javalogger.mixpanel.MixpanelHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    private static Logger instance;
    private File logFolder = new File(System.getenv("PROGRAMDATA") + File.separator + "JavaLogger");
    private File currentLogFile = new File(this.logFolder.getPath() + File.separator + Logger.getLogFileDate() + ".log");
    private boolean isDebug;
    private boolean isVerbose;
    private int verboseLevel = 0;
    private boolean smallLog;
    private boolean consoleExceptions;
    private boolean projectName;
    static Map<String, LogTemplate> templates;

    private Logger() {
    }

    public static Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public void setLogFolder(File logFolder) {
        this.logFolder = logFolder;
        this.currentLogFile = new File(logFolder.getPath() + File.separator + Logger.getLogFileDate() + ".log");
    }

    public void setDebug(boolean isDebugMode) {
        this.isDebug = isDebugMode;
    }

    public void setVerbose(boolean isVerboseMode) {
        this.isVerbose = isVerboseMode;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    public void setSmallLog(boolean ignorePrefixes) {
        this.smallLog = ignorePrefixes;
    }

    public void setConsoleExceptions(boolean showExceptionsInConsole) {
        this.consoleExceptions = showExceptionsInConsole;
    }

    public void setProjectName(boolean showProjectName) {
        this.projectName = showProjectName;
    }

    public static void log(LogEntry log) {
        boolean verboseLevelOK;
        String logOutput = Logger.createLogString(log);
        boolean debugOK = !log.onlyDebug || Logger.getInstance().isDebug;
        boolean verboseOK = !log.onlyVerbose || Logger.getInstance().isVerbose;
        boolean bl = verboseLevelOK = log.verboseLevel <= Logger.getInstance().verboseLevel;
        if (debugOK && verboseOK && verboseLevelOK) {
            System.out.println(log.color + log.background + logOutput + "\u001b[0m");
            if (log.exception != null && (Logger.getInstance().consoleExceptions || log.consoleException)) {
                log.exception.printStackTrace();
            }
        }
        if (log.fileEntry) {
            Logger.getInstance().addEntryToLogFile(log, logOutput);
        }
        if (log.mixpanel) {
            Logger.sendMixpanelMessage(log);
        }
    }

    public static boolean log(String text, String templateName, Exception e, int errorCode) {
        LogEntry log;
        try {
            log = new LogEntry(text, templateName);
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
        log.EXCEPTION(e);
        log.CODE(errorCode);
        Logger.log(log);
        return true;
    }

    public static boolean log(String text, Enum<?> templateName, Exception e, int errorCode) {
        return Logger.log(text, templateName.name(), e, errorCode);
    }

    public static boolean log(String text, String templateName, Exception e) {
        return Logger.log(text, templateName, e, 0);
    }

    public static boolean log(String text, Enum<?> templateName, Exception e) {
        return Logger.log(text, templateName, e, 0);
    }

    public static boolean log(String text, String templateName) {
        return Logger.log(text, templateName, null);
    }

    public static boolean log(String text, Enum<?> template) {
        return Logger.log(text, template, null);
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String backgroundColorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, int verboseLevel, boolean onlyDebug, boolean hidePrefix, boolean exceptionsInConsole, boolean mixpanelMessage, String mixpanelName, String projectName) {
        boolean isNew = !templates.containsKey(templateName);
        templates.put(templateName, new LogTemplate(colorCode, backgroundColorCode, logLevel, writeToFile, onlyVerbose, verboseLevel, onlyDebug, hidePrefix, exceptionsInConsole, mixpanelMessage, mixpanelName, projectName));
        return isNew;
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String backgroundColorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, int verboseLevel, boolean onlyDebug, boolean hidePrefix, boolean exceptionsInConsole, boolean mixpanelMessage, String mixpanelName, String projectName) {
        return Logger.createNewTemplate(templateName.name(), colorCode, backgroundColorCode, logLevel, writeToFile, onlyVerbose, verboseLevel, onlyDebug, hidePrefix, exceptionsInConsole, mixpanelMessage, mixpanelName, "JavaLogger");
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String backgroundColorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, int verboseLevel, boolean onlyDebug, boolean hidePrefix, boolean exceptionsInConsole, boolean mixpanelMessage, String mixpanelName) {
        return Logger.createNewTemplate(templateName, colorCode, backgroundColorCode, logLevel, writeToFile, onlyVerbose, 0, onlyDebug, hidePrefix, exceptionsInConsole, mixpanelMessage, mixpanelName, "JavaLogger");
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String backgroundColorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, int verboseLevel, boolean onlyDebug, boolean hidePrefix, boolean exceptionsInConsole, boolean mixpanelMessage, String mixpanelName) {
        return Logger.createNewTemplate(templateName, colorCode, backgroundColorCode, logLevel, writeToFile, onlyVerbose, verboseLevel, onlyDebug, hidePrefix, exceptionsInConsole, mixpanelMessage, mixpanelName, "JavaLogger");
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String backgroundColorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix, boolean exceptionsInConsole, boolean mixpanelMessage, String mixpanelName) {
        return Logger.createNewTemplate(templateName, colorCode, backgroundColorCode, logLevel, writeToFile, onlyVerbose, 0, onlyDebug, hidePrefix, exceptionsInConsole, mixpanelMessage, mixpanelName);
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String backgroundColorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix, boolean exceptionsInConsole, boolean mixpanelMessage, String mixpanelName) {
        return Logger.createNewTemplate(templateName, colorCode, backgroundColorCode, logLevel, writeToFile, onlyVerbose, 0, onlyDebug, hidePrefix, exceptionsInConsole, mixpanelMessage, mixpanelName);
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String backgroundColorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix, boolean mixpanelMessage, String mixpanelName) {
        return Logger.createNewTemplate(templateName, colorCode, backgroundColorCode, logLevel, writeToFile, onlyVerbose, onlyDebug, hidePrefix, false, mixpanelMessage, mixpanelName);
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String backgroundColorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix, boolean mixpanelMessage, String mixpanelName) {
        return Logger.createNewTemplate(templateName, colorCode, backgroundColorCode, logLevel, writeToFile, onlyVerbose, onlyDebug, hidePrefix, false, mixpanelMessage, mixpanelName);
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix, boolean mixpanelMessage, String mixpanelName) {
        return Logger.createNewTemplate(templateName, colorCode, "", logLevel, writeToFile, onlyVerbose, onlyDebug, hidePrefix, mixpanelMessage, mixpanelName);
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix, boolean mixpanelMessage, String mixpanelName) {
        return Logger.createNewTemplate(templateName, colorCode, "", logLevel, writeToFile, onlyVerbose, onlyDebug, hidePrefix, mixpanelMessage, mixpanelName);
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix, boolean mixpanelMessage) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, writeToFile, onlyVerbose, onlyDebug, hidePrefix, mixpanelMessage, "LOG");
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix, boolean mixpanelMessage) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, writeToFile, onlyVerbose, onlyDebug, hidePrefix, mixpanelMessage, "LOG");
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, writeToFile, onlyVerbose, onlyDebug, hidePrefix, false);
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug, boolean hidePrefix) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, writeToFile, onlyVerbose, onlyDebug, hidePrefix, false);
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, writeToFile, onlyVerbose, onlyDebug, false);
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String logLevel, boolean writeToFile, boolean onlyVerbose, boolean onlyDebug) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, writeToFile, onlyVerbose, onlyDebug, false);
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String logLevel, boolean writeToFile) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, writeToFile, false, false);
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String logLevel, boolean writeToFile) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, writeToFile, false, false);
    }

    public static boolean createNewTemplate(String templateName, String colorCode, String logLevel) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, true);
    }

    public static boolean createNewTemplate(Enum<?> templateName, String colorCode, String logLevel) {
        return Logger.createNewTemplate(templateName, colorCode, logLevel, true);
    }

    private static String createLogString(LogEntry log) {
        if (log.plainText || Logger.getInstance().smallLog) {
            return log.message;
        }
        String errorCode = log.errorCode == 0 ? "[---]" : "[" + log.errorCode + "]";
        String prefix = "[" + log.loglevel + "]";
        String projectName = Logger.getInstance().projectName ? "[" + log.projectName + "]" : "";
        return Logger.getLogEntryDate() + prefix + errorCode + projectName + log.message;
    }

    private static String getLogEntryDate() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS");
        LocalDateTime now = LocalDateTime.now();
        return "[" + dtf.format(now) + "]";
    }

    private void addEntryToLogFile(LogEntry log, String logOutput) {
        if (!this.currentLogFile.exists()) {
            this.createLogFile();
        }
        try {
            ArrayList<String> fileContent = new ArrayList<String>(Files.readAllLines(this.currentLogFile.toPath(), StandardCharsets.UTF_8));
            fileContent.add(logOutput);
            if (log.exception != null) {
                fileContent.add("\t" + Arrays.toString(log.exception.getStackTrace()).replace(", ", "\n\t").replace("[", "").replace("]", ""));
            }
            Files.write(this.currentLogFile.toPath(), fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            LogEntry l = new LogEntry("Something went wrong when writing to the log-file").COLOR("\u001b[0;91m").LEVEL("ERR").EXCEPTION(e).CODE(0).FILE_ENTRY(false);
            Logger.log(l);
        }
    }

    private static void sendMixpanelMessage(LogEntry entry) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("message", Logger.createLogString(entry));
        props.put("logLevel", entry.loglevel);
        props.put("projectName", entry.projectName);
        if (entry.errorCode != 0) {
            props.put("errorCode", String.valueOf(entry.errorCode));
        }
        if (entry.exception != null) {
            props.put("exception", Arrays.toString(entry.exception.getStackTrace()));
        }
        MixpanelHandler.addMessage(entry.mixpanelEventName, props);
    }

    private static String getLogFileDate() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
        LocalDateTime now = LocalDateTime.now();
        return dtf.format(now);
    }

    private void createLogFile() {
        LogEntry l;
        try {
            Files.createDirectories(this.logFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            l = new LogEntry("Could not create log-directory: " + String.valueOf(this.logFolder)).COLOR("\u001b[0;91m").LEVEL("ERR").CODE(0).EXCEPTION(e).FILE_ENTRY(false);
            Logger.log(l);
        }
        try {
            this.currentLogFile.createNewFile();
        }
        catch (IOException e) {
            l = new LogEntry("Could not create file: " + String.valueOf(this.currentLogFile)).COLOR("\u001b[0;91m").LEVEL("ERR").CODE(0).EXCEPTION(e).FILE_ENTRY(false);
            Logger.log(l);
        }
    }

    static {
        templates = new HashMap<String, LogTemplate>(){
            {
                this.put(LogLevel.VERBOSE.name(), new LogTemplate("\u001b[0;37m", "", "VER", false, true, 0, false, false, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.VVERBOSE.name(), new LogTemplate("\u001b[0;37m", "", "VER", false, true, 1, false, false, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.VVVERBOSE.name(), new LogTemplate("\u001b[0;37m", "", "VER", false, true, 2, false, false, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.INFO.name(), new LogTemplate("\u001b[0;97m", "", "INF", true, false, 0, true, false, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.WARNING.name(), new LogTemplate("\u001b[0;93m", "", "WRN", true, false, 0, false, false, false, true, "LOG", "JavaLogger"));
                this.put(LogLevel.ERROR.name(), new LogTemplate("\u001b[0;91m", "", "ERR", true, false, 0, false, false, true, true, "LOG", "JavaLogger"));
                this.put(LogLevel.SPECIAL.name(), new LogTemplate("\u001b[0;32m", "", "SPE", false, false, 0, false, false, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.RESPONSE.name(), new LogTemplate("\u001b[0;34m", "", "RES", false, false, 0, false, false, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.QUESTION.name(), new LogTemplate("\u001b[0;96m", "", "QUE", false, false, 0, false, false, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.CLEAN_INFO.name(), new LogTemplate("\u001b[0;97m", "", "INF", true, false, 0, true, true, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.CLEAN_SPECIAL.name(), new LogTemplate("\u001b[0;32m", "", "SPE", false, false, 0, false, true, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.CLEAN_RESPONSE.name(), new LogTemplate("\u001b[0;34m", "", "RES", false, false, 0, false, true, false, false, "LOG", "JavaLogger"));
                this.put(LogLevel.CLEAN_QUESTION.name(), new LogTemplate("\u001b[0;96m", "", "QUE", false, false, 0, false, true, false, false, "LOG", "JavaLogger"));
            }
        };
    }
}

