/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.expr.atoms;

import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.List;
import java.util.Objects;

public class Atom
extends Expression {
    static int PRECEDENCE = 190;
    Expression atomElement;
    List<Expression> trailers;

    @Override
    public int getPrecedence() {
        return PRECEDENCE;
    }

    public Atom(Expression atomElement, List<Expression> trailers) {
        this.atomElement = atomElement;
        this.trailers = trailers;
        this.setParent();
    }

    private void setParent() {
        if (this.trailers != null) {
            for (Expression trailer : this.trailers) {
                trailer.setParent(this);
            }
        }
    }

    public Expression getAtomElement() {
        return this.atomElement;
    }

    public void setAtomElement(Expression atomElement) {
        this.atomElement = atomElement;
    }

    public List<Expression> getTrailers() {
        return this.trailers;
    }

    public void setTrailers(List<Expression> trailers) {
        this.trailers = trailers;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitAtom(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Atom atom = (Atom)o;
        return Objects.equals(this.atomElement, atom.atomElement) && Objects.equals(this.trailers, atom.trailers);
    }

    public int hashCode() {
        return Objects.hash(this.atomElement, this.trailers);
    }
}

