/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.expr.datastructures;

import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.List;
import java.util.Objects;

public class Tuple
extends Expression {
    static int PRECEDENCE = 170;
    List<Expression> elts;

    @Override
    public int getPrecedence() {
        return PRECEDENCE;
    }

    public Tuple(List<Expression> elts) {
        this.elts = elts;
        this.setParents();
    }

    private void setParents() {
        if (this.elts != null) {
            for (Expression expr : this.elts) {
                if (expr == null) continue;
                expr.setParent(this);
            }
        }
    }

    public List<Expression> getElts() {
        return this.elts;
    }

    public void setElts(List<Expression> elts) {
        this.elts = elts;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitTuple(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Objects.equals(this.elts, tuple.elts);
    }

    public int hashCode() {
        return Objects.hash(this.elts);
    }
}

