/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts;

import io.github.danielnaczo.python3parser.model.Identifier;
import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.stmts.Body;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.Decorator;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.FunctionDef;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ClassDef
extends Statement {
    Identifier name;
    Optional<Expression> arguments;
    Statement body;
    List<Decorator> decoratorList;

    public ClassDef(String name) {
        this(name, null, null, new ArrayList<Decorator>());
    }

    public ClassDef(String name, Expression arguments) {
        this(name, arguments, null, new ArrayList<Decorator>());
    }

    public ClassDef(String name, Statement body) {
        this(name, null, body, new ArrayList<Decorator>());
    }

    public ClassDef(String name, Expression arguments, Statement body) {
        this(name, arguments, body, new ArrayList<Decorator>());
    }

    public ClassDef(String name, Statement body, List<Decorator> decoratorList) {
        this(name, null, body, decoratorList);
    }

    public ClassDef(String name, Expression arguments, Statement body, List<Decorator> decoratorList) {
        this(new Identifier(name), arguments, body, decoratorList);
    }

    public ClassDef(Identifier name, Expression arguments, Statement body, List<Decorator> decoratorList) {
        this.name = name;
        this.arguments = Optional.ofNullable(arguments);
        this.body = body;
        this.setParentToBody();
        this.decoratorList = decoratorList;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public Optional<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(Optional<Expression> arguments) {
        this.arguments = arguments;
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement body) {
        this.body = body;
        this.setParentToBody();
    }

    public List<Decorator> getDecoratorList() {
        return this.decoratorList;
    }

    public void setDecoratorList(List<Decorator> decoratorList) {
        this.decoratorList = decoratorList;
    }

    public ClassDef addClass(ClassDef clazz) {
        this.addStatement(clazz);
        return clazz;
    }

    public FunctionDef addFunction(FunctionDef function) {
        this.addStatement(function);
        return function;
    }

    public Statement addStatement(Statement statement) {
        if (this.body == null) {
            this.body = statement;
            return statement;
        }
        this.body = this.transformStmtToBody();
        Body body = (Body)this.body;
        body.addStatement(statement);
        return statement;
    }

    public List<ClassDef> getClassDefs() {
        Body body = this.transformStmtToBody();
        List<Statement> statements = body.getStatements();
        ArrayList<ClassDef> classes = new ArrayList<ClassDef>();
        for (Statement statement : statements) {
            if (!(statement instanceof ClassDef)) continue;
            classes.add((ClassDef)statement);
        }
        return classes;
    }

    public List<FunctionDef> getFunctionDefs() {
        Body body = this.transformStmtToBody();
        List<Statement> statements = body.getStatements();
        ArrayList<FunctionDef> functions = new ArrayList<FunctionDef>();
        for (Statement statement : statements) {
            if (!(statement instanceof FunctionDef)) continue;
            functions.add((FunctionDef)statement);
        }
        return functions;
    }

    public Decorator addDecorator(Decorator decorator) {
        if (this.decoratorList == null) {
            this.decoratorList = new ArrayList<Decorator>();
        }
        this.decoratorList.add(decorator);
        return decorator;
    }

    public List<Decorator> getDecorators() {
        return this.getDecoratorList();
    }

    private Body transformStmtToBody() {
        if (this.body instanceof Body) {
            return (Body)this.body;
        }
        Statement statement = this.body;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(statement);
        Body body = new Body(statements);
        body.setParentStmt(this);
        return body;
    }

    private void setParentToBody() {
        if (this.body instanceof Body) {
            ((Body)this.body).setParentStmt(this);
        }
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitClassDef(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDef classDef = (ClassDef)o;
        return Objects.equals(this.name, classDef.name) && Objects.equals(this.arguments, classDef.arguments) && Objects.equals(this.body, classDef.body) && Objects.equals(this.decoratorList, classDef.decoratorList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments, this.body, this.decoratorList);
    }

    public String toString() {
        return "ClassDef '" + this.name.getName() + "'";
    }
}

