/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts.forStmts;

import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.stmts.Body;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public class AsyncFor
extends Statement {
    Expression target;
    Expression iter;
    Statement body;
    Optional<Statement> orElse;

    public AsyncFor() {
        this(null, null, null, null);
    }

    public AsyncFor(Expression target) {
        this(target, null, null, null);
    }

    public AsyncFor(Expression target, Expression iter) {
        this(target, iter, null, null);
    }

    public AsyncFor(Expression target, Expression iter, Statement body) {
        this(target, iter, body, null);
    }

    public AsyncFor(Expression target, Expression iter, Statement body, Statement orElse) {
        this.target = target;
        this.iter = iter;
        this.body = body;
        this.orElse = Optional.ofNullable(orElse);
        this.setParentToBody();
        this.setParentToOrElse();
    }

    public Expression getTarget() {
        return this.target;
    }

    public Expression getIter() {
        return this.iter;
    }

    public Statement getBody() {
        return this.body;
    }

    public Optional<Statement> getOrElse() {
        return this.orElse;
    }

    public void setTarget(Expression target) {
        this.target = target;
    }

    public void setIter(Expression iter) {
        this.iter = iter;
    }

    public void setBody(Statement body) {
        this.body = body;
        this.setParentToBody();
    }

    public void setOrElse(Optional<Statement> orElse) {
        this.orElse = orElse;
        this.setParentToOrElse();
    }

    public Statement addStatement(Statement statement) {
        if (this.body == null) {
            this.body = statement;
            return statement;
        }
        this.body = this.transformStmtToBody();
        Body body = (Body)this.body;
        body.addStatement(statement);
        return statement;
    }

    private void setParentToBody() {
        if (this.body instanceof Body) {
            ((Body)this.body).setParentStmt(this);
        }
    }

    private void setParentToOrElse() {
        Statement orElseStmt;
        if (this.orElse.isPresent() && (orElseStmt = this.orElse.get()) instanceof Body) {
            ((Body)orElseStmt).setParentStmt(this);
        }
    }

    private Body transformStmtToBody() {
        if (this.body instanceof Body) {
            return (Body)this.body;
        }
        Statement statement = this.body;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(statement);
        Body body = new Body(statements);
        body.setParentStmt(this);
        return body;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitAsyncFor(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFor asyncFor = (AsyncFor)o;
        return Objects.equals(this.target, asyncFor.target) && Objects.equals(this.iter, asyncFor.iter) && Objects.equals(this.body, asyncFor.body) && Objects.equals(this.orElse, asyncFor.orElse);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.iter, this.body, this.orElse);
    }

    public String toString() {
        return "AsyncFor";
    }
}

