/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.parameters;

import io.github.danielnaczo.python3parser.model.AST;
import io.github.danielnaczo.python3parser.model.Identifier;
import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.Objects;
import java.util.Optional;

public class Parameter
implements AST {
    Identifier parameterName;
    Optional<Expression> annotation;

    public Parameter(String parameterName) {
        this(parameterName, null);
    }

    public Parameter(String parameterName, Expression annotation) {
        this(new Identifier(parameterName), annotation);
    }

    public Parameter(Identifier parameterName, Expression annotation) {
        this.parameterName = parameterName;
        this.annotation = Optional.ofNullable(annotation);
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitParameter(this, param);
    }

    public Identifier getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(Identifier parameterName) {
        this.parameterName = parameterName;
    }

    public Optional<Expression> getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Optional<Expression> annotation) {
        this.annotation = annotation;
    }

    public String getParameterNameAsString() {
        return this.parameterName.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter arg1 = (Parameter)o;
        return Objects.equals(this.parameterName, arg1.parameterName) && Objects.equals(this.annotation, arg1.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.parameterName, this.annotation);
    }
}

