/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.manipulation;

import io.github.danielnaczo.python3parser.Python3Lexer;
import io.github.danielnaczo.python3parser.Python3Parser;
import io.github.danielnaczo.python3parser.model.AST;
import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.expr.atoms.Atom;
import io.github.danielnaczo.python3parser.model.expr.atoms.Str;
import io.github.danielnaczo.python3parser.model.stmts.Body;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.ClassDef;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.AsyncFunctionDef;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.FunctionDef;
import io.github.danielnaczo.python3parser.model.stmts.smallStmts.assignStmts.Assign;
import io.github.danielnaczo.python3parser.visitors.ast.ModuleVisitor;
import io.github.danielnaczo.python3parser.visitors.modifier.ModifierVisitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class DocstringManipulation {
    public static void main(String[] args) throws IOException {
        CharStream charStream = CharStreams.fromFileName((String)"trunk/examples/lib/_collections_abc.py");
        Python3Lexer lexer = new Python3Lexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        AST ast = (AST)moduleVisitor.visit((ParseTree)parser.file_input());
        HashMap docstringCollector = new HashMap();
        DocstringModifier docstringModifier = new DocstringModifier();
        docstringModifier.visitAST(ast, docstringCollector);
        for (Map.Entry entry : docstringCollector.entrySet()) {
            String functionDefName = (String)entry.getKey();
            String docstring = (String)entry.getValue();
            System.out.println("FunctionDef " + functionDefName + ":");
            System.out.println(docstring);
            System.out.println();
        }
    }

    private static class DocstringModifier
    extends ModifierVisitor<HashMap<String, String>> {
        private DocstringModifier() {
        }

        @Override
        public AST visitFunctionDef(FunctionDef functionDef, HashMap<String, String> docstringCollector) {
            Atom atom;
            Expression atomElement;
            Assign firstAssign;
            Statement firstStmt;
            super.visitFunctionDef(functionDef, docstringCollector);
            Body body = (Body)functionDef.getBody();
            List<Statement> statements = body.getStatements();
            if (statements != null && !statements.isEmpty() && (firstStmt = statements.get(0)) instanceof Assign && !(firstAssign = (Assign)firstStmt).getValue().isPresent() && (atomElement = (atom = (Atom)firstAssign.getTargets().get(0)).getAtomElement()) instanceof Str) {
                Str string = (Str)atomElement;
                String docstring = string.getS();
                docstringCollector.put(functionDef.getName().getName(), docstring);
            }
            return functionDef;
        }

        @Override
        public AST visitAsyncFunctionDef(AsyncFunctionDef asyncFunctionDef, HashMap<String, String> docstringCollector) {
            Atom atom;
            Expression atomElement;
            Assign firstAssign;
            Statement firstStmt;
            super.visitAsyncFunctionDef(asyncFunctionDef, docstringCollector);
            Body body = (Body)asyncFunctionDef.getBody();
            List<Statement> statements = body.getStatements();
            if (statements != null && !statements.isEmpty() && (firstStmt = statements.get(0)) instanceof Assign && !(firstAssign = (Assign)firstStmt).getValue().isPresent() && (atomElement = (atom = (Atom)firstAssign.getTargets().get(0)).getAtomElement()) instanceof Str) {
                Str string = (Str)atomElement;
                String docstring = string.getS();
                docstringCollector.put(asyncFunctionDef.getName().getName(), docstring);
            }
            return asyncFunctionDef;
        }

        @Override
        public AST visitClassDef(ClassDef classDef, HashMap<String, String> docstringCollector) {
            Atom atom;
            Expression atomElement;
            Assign firstAssign;
            Statement firstStmt;
            super.visitClassDef(classDef, docstringCollector);
            Body body = (Body)classDef.getBody();
            List<Statement> statements = body.getStatements();
            if (statements != null && !statements.isEmpty() && (firstStmt = statements.get(0)) instanceof Assign && !(firstAssign = (Assign)firstStmt).getValue().isPresent() && (atomElement = (atom = (Atom)firstAssign.getTargets().get(0)).getAtomElement()) instanceof Str) {
                Str string = (Str)atomElement;
                String docstring = string.getS();
                docstringCollector.put(classDef.getName().getName(), docstring);
            }
            return classDef;
        }
    }
}

