/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.expr;

import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.List;
import java.util.Objects;

public class ExpressionsList
extends Expression {
    static int PRECEDENCE = 0;
    List<Expression> expressions;

    @Override
    public int getPrecedence() {
        return PRECEDENCE;
    }

    public ExpressionsList(List<Expression> expressions) {
        this.expressions = expressions;
        this.setParents();
    }

    private void setParents() {
        if (this.expressions != null) {
            for (Expression expr : this.expressions) {
                if (expr == null) continue;
                expr.setParent(this);
            }
        }
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitExpressionList(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionsList)) {
            return false;
        }
        ExpressionsList that = (ExpressionsList)o;
        return Objects.equals(this.expressions, that.expressions);
    }

    public int hashCode() {
        return Objects.hash(this.expressions);
    }
}

