/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts;

import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.stmts.Body;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class If
extends Statement {
    Expression ifTest;
    Statement ifBody;
    List<Expression> elifTests;
    List<Statement> elifBodies;
    Optional<Statement> elseBody;

    public If(Expression ifTest) {
        this(ifTest, null, null, null, null);
    }

    public If(Expression ifTest, Statement ifBody) {
        this(ifTest, ifBody, null, null, null);
    }

    public If(Expression ifTest, Statement ifBody, List<Expression> elifTests, List<Statement> elifBodies) {
        this(ifTest, ifBody, elifTests, elifBodies, null);
    }

    public If(Expression ifTest, Statement ifBody, Statement elseBody) {
        this(ifTest, ifBody, null, null, elseBody);
    }

    public If(Expression ifTest, Statement ifBody, List<Expression> elifTests, List<Statement> elifBodies, Statement elseBody) {
        this.ifTest = ifTest;
        this.ifBody = ifBody;
        this.elifTests = elifTests != null ? elifTests : new ArrayList();
        this.elifBodies = elifBodies != null ? elifBodies : new ArrayList();
        this.elseBody = Optional.ofNullable(elseBody);
        this.setParentToBodies();
    }

    public Expression getIfTest() {
        return this.ifTest;
    }

    public void setIfTest(Expression ifTest) {
        this.ifTest = ifTest;
    }

    public Statement getIfBody() {
        return this.ifBody;
    }

    public void setIfBody(Statement ifBody) {
        this.ifBody = ifBody;
        this.setParentToIfBody();
    }

    public List<Expression> getElifTests() {
        return this.elifTests;
    }

    public void setElifTests(List<Expression> elifTests) {
        this.elifTests = elifTests;
    }

    public List<Statement> getElifBodies() {
        return this.elifBodies;
    }

    public void setElifBodies(List<Statement> elifBodies) {
        this.elifBodies = elifBodies;
        this.setParentToElifBodies();
    }

    public Optional<Statement> getElseBody() {
        return this.elseBody;
    }

    public void setElseBody(Optional<Statement> elseBody) {
        this.elseBody = elseBody;
        this.setParentToElseBody();
    }

    public Statement addStatementToBody(Statement statement) {
        if (this.ifBody == null) {
            this.ifBody = statement;
            return statement;
        }
        this.ifBody = this.transformStmtToBody();
        Body body = (Body)this.ifBody;
        body.addStatement(statement);
        return statement;
    }

    public Expression addElifTestWithBody(Expression elifTest, Statement elifBody) {
        this.elifTests.add(elifTest);
        this.elifBodies.add(elifBody);
        this.setParentToElifBodies();
        return elifTest;
    }

    public Statement addStatementToElif(Expression elifTest, Statement elifStatement) {
        if (!this.elifTests.contains(elifTest)) {
            throw new NoSuchElementException("ElifTest does not exist in attribute 'elifTests'.");
        }
        int indexOfElifTest = this.elifTests.indexOf(elifTest);
        if (this.elifBodies.get(indexOfElifTest) instanceof Body) {
            Body body = (Body)this.elifBodies.get(indexOfElifTest);
            body.addStatement(elifStatement);
        } else {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add(this.elifBodies.get(indexOfElifTest));
            statements.add(elifStatement);
            Body body = new Body(statements);
            body.setParentStmt(this);
            this.elifBodies.remove(indexOfElifTest);
            this.elifBodies.add(indexOfElifTest, body);
        }
        return elifStatement;
    }

    private Body transformStmtToBody() {
        if (this.ifBody instanceof Body) {
            return (Body)this.ifBody;
        }
        Statement statement = this.ifBody;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(statement);
        Body body = new Body(statements);
        body.setParentStmt(this);
        return body;
    }

    private void setParentToBodies() {
        this.setParentToIfBody();
        this.setParentToElifBodies();
        this.setParentToElseBody();
    }

    private void setParentToIfBody() {
        if (this.ifBody instanceof Body) {
            ((Body)this.ifBody).setParentStmt(this);
        }
    }

    private void setParentToElifBodies() {
        for (Statement statement : this.elifBodies) {
            if (!(statement instanceof Body)) continue;
            ((Body)statement).setParentStmt(this);
        }
    }

    private void setParentToElseBody() {
        Statement elseSuiteStmt;
        if (this.elseBody.isPresent() && (elseSuiteStmt = this.elseBody.get()) instanceof Body) {
            ((Body)elseSuiteStmt).setParentStmt(this);
        }
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitIf(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        If anIf = (If)o;
        return Objects.equals(this.ifTest, anIf.ifTest) && Objects.equals(this.ifBody, anIf.ifBody) && Objects.equals(this.elifTests, anIf.elifTests) && Objects.equals(this.elifBodies, anIf.elifBodies) && Objects.equals(this.elseBody, anIf.elseBody);
    }

    public int hashCode() {
        return Objects.hash(this.ifTest, this.ifBody, this.elifTests, this.elifBodies, this.elseBody);
    }

    public String toString() {
        return "If";
    }
}

