/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts;

import io.github.danielnaczo.python3parser.model.AST;
import io.github.danielnaczo.python3parser.model.Identifier;
import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.Objects;
import java.util.Optional;

public class Decorator
implements AST {
    Identifier name;
    Optional<Expression> arguments;

    public Decorator(String name) {
        this(name, null);
    }

    public Decorator(String name, Expression arguments) {
        this(new Identifier(name), arguments);
    }

    public Decorator(Identifier name, Expression arguments) {
        this.name = name;
        this.arguments = Optional.ofNullable(arguments);
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public Optional<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(Optional<Expression> arguments) {
        this.arguments = arguments;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitDecorator(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decorator decorator = (Decorator)o;
        return Objects.equals(this.name, decorator.name) && Objects.equals(this.arguments, decorator.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }
}

