/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts;

import io.github.danielnaczo.python3parser.model.Identifier;
import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.stmts.Body;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.ClassDef;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.Decorator;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.parameters.DefaultParameter;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.parameters.Parameter;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.parameters.Parameters;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionDef
extends Statement {
    Identifier name;
    Optional<Parameters> parameters;
    Statement body;
    List<Decorator> decoratorList;
    Optional<Expression> returns;

    public FunctionDef(String name) {
        this(new Identifier(name), null, null, null, null);
    }

    public FunctionDef(String name, Parameters parameters) {
        this(new Identifier(name), parameters, null, null, null);
    }

    public FunctionDef(String name, Statement body) {
        this(new Identifier(name), null, body, null, null);
    }

    public FunctionDef(String name, Parameters parameters, Statement body) {
        this(new Identifier(name), parameters, body, null, null);
    }

    public FunctionDef(String name, Parameters parameters, Statement body, Expression returns) {
        this(new Identifier(name), parameters, body, null, returns);
    }

    public FunctionDef(String name, Parameters parameters, Statement body, List<Decorator> decaratorList, Expression returns) {
        this(new Identifier(name), parameters, body, decaratorList, returns);
    }

    public FunctionDef(Identifier name, Parameters parameters, Statement body, List<Decorator> decaratorList, Expression returns) {
        this.name = name;
        this.parameters = Optional.ofNullable(parameters);
        this.body = body;
        this.decoratorList = decaratorList;
        this.returns = Optional.ofNullable(returns);
        this.setParentToBody();
    }

    public Identifier getName() {
        return this.name;
    }

    public Optional<Parameters> getParameters() {
        return this.parameters;
    }

    public Statement getBody() {
        return this.body;
    }

    public List<Decorator> getDecoratorList() {
        return this.decoratorList;
    }

    public Optional<Expression> getReturns() {
        return this.returns;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public void setParameters(Optional<Parameters> parameters) {
        this.parameters = parameters;
    }

    public void setBody(Statement body) {
        this.body = body;
        this.setParentToBody();
    }

    public void setDecoratorList(List<Decorator> decoratorList) {
        this.decoratorList = decoratorList;
    }

    public void setReturns(Optional<Expression> returns) {
        this.returns = returns;
    }

    public Parameter addParameter(Parameter param) {
        Parameters parameters;
        if (!this.parameters.isPresent()) {
            this.parameters = Optional.ofNullable(new Parameters());
        }
        if ((parameters = this.parameters.get()).getParams() == null) {
            parameters.setParams(new ArrayList<Parameter>());
        }
        parameters.getParams().add(param);
        return param;
    }

    public DefaultParameter addDefaultParameter(DefaultParameter defaultParam) {
        Parameters parameters;
        if (!this.parameters.isPresent()) {
            this.parameters = Optional.ofNullable(new Parameters());
        }
        if ((parameters = this.parameters.get()).getDefaultParams() == null) {
            parameters.setDefaultParams(new ArrayList<DefaultParameter>());
        }
        parameters.getDefaultParams().add(defaultParam);
        return defaultParam;
    }

    public Parameter setVarParameter(Parameter varParam) {
        if (!this.parameters.isPresent()) {
            this.parameters = Optional.ofNullable(new Parameters());
        }
        this.parameters.get().setVarParam(Optional.ofNullable(varParam));
        return varParam;
    }

    public Parameter addKeyWordParameter(Parameter param) {
        Parameters parameters;
        if (!this.parameters.isPresent()) {
            this.parameters = Optional.ofNullable(new Parameters());
        }
        if ((parameters = this.parameters.get()).getKwonlyParams() == null) {
            parameters.setKwonlyParams(new ArrayList<Parameter>());
        }
        parameters.getKwonlyParams().add(param);
        return param;
    }

    public DefaultParameter addKeyWordDefaultParameter(DefaultParameter defaultParam) {
        Parameters parameters;
        if (!this.parameters.isPresent()) {
            this.parameters = Optional.ofNullable(new Parameters());
        }
        if ((parameters = this.parameters.get()).getKwDefaultParams() == null) {
            parameters.setKwDefaultParams(new ArrayList<DefaultParameter>());
        }
        parameters.getKwDefaultParams().add(defaultParam);
        return defaultParam;
    }

    public Parameter setVarDefaultParameter(Parameter varKwParam) {
        if (!this.parameters.isPresent()) {
            this.parameters = Optional.ofNullable(new Parameters());
        }
        this.parameters.get().setKwParam(Optional.ofNullable(varKwParam));
        return varKwParam;
    }

    public FunctionDef addFunction(FunctionDef function) {
        this.addStatement(function);
        return function;
    }

    public ClassDef addFunction(ClassDef clazz) {
        this.addStatement(clazz);
        return clazz;
    }

    public Statement addStatement(Statement statement) {
        if (this.body == null) {
            this.body = statement;
            return statement;
        }
        this.body = this.transformStmtToBody();
        Body body = (Body)this.body;
        body.addStatement(statement);
        return statement;
    }

    public Decorator addDecorator(Decorator decorator) {
        if (this.decoratorList == null) {
            this.decoratorList = new ArrayList<Decorator>();
        }
        this.decoratorList.add(decorator);
        return decorator;
    }

    public List<Decorator> getDecorators() {
        return this.getDecoratorList();
    }

    private void setParentToBody() {
        if (this.body instanceof Body) {
            ((Body)this.body).setParentStmt(this);
        }
    }

    private Body transformStmtToBody() {
        if (this.body instanceof Body) {
            return (Body)this.body;
        }
        Statement statement = this.body;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(statement);
        Body body = new Body(statements);
        body.setParentStmt(this);
        return body;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitFunctionDef(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionDef that = (FunctionDef)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.body, that.body) && Objects.equals(this.decoratorList, that.decoratorList) && Objects.equals(this.returns, that.returns);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parameters, this.body, this.decoratorList, this.returns);
    }

    public String toString() {
        return "FunctionDef '" + this.name.getName() + "'";
    }
}

