/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts.tryExceptStmts;

import io.github.danielnaczo.python3parser.model.stmts.Body;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.tryExceptStmts.ExceptHandler;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class Try
extends Statement {
    Statement body;
    List<ExceptHandler> handlers;
    List<Statement> handlersBody;
    Optional<Statement> orElse;
    Optional<Statement> finalBody;

    public Try() {
        this(null, null, null, null, null);
    }

    public Try(Statement body) {
        this(body, null, null, null, null);
    }

    public Try(Statement body, List<ExceptHandler> handlers) {
        this(body, handlers, null, null, null);
    }

    public Try(Statement body, List<ExceptHandler> handlers, List<Statement> handlersBody) {
        this(body, handlers, handlersBody, null, null);
    }

    public Try(Statement body, List<ExceptHandler> handlers, List<Statement> handlersBody, Statement orElse) {
        this(body, handlers, handlersBody, orElse, null);
    }

    public Try(Statement body, List<ExceptHandler> handlers, List<Statement> handlersBody, Statement orElse, Statement finalBody) {
        this.body = body;
        this.handlers = handlers != null ? handlers : new ArrayList();
        this.handlersBody = handlersBody != null ? handlersBody : new ArrayList();
        this.orElse = Optional.ofNullable(orElse);
        this.finalBody = Optional.ofNullable(finalBody);
        this.setParentToBodies();
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement body) {
        this.body = body;
        this.setParentToBody();
    }

    public List<ExceptHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<ExceptHandler> handlers) {
        this.handlers = handlers;
    }

    public List<Statement> getHandlersBody() {
        return this.handlersBody;
    }

    public void setHandlersBody(List<Statement> handlersBody) {
        this.handlersBody = handlersBody;
        this.setParentToHandlersBody();
    }

    public Optional<Statement> getOrElse() {
        return this.orElse;
    }

    public void setOrElse(Optional<Statement> orElse) {
        this.orElse = orElse;
        this.setParentToOrElse();
    }

    public Optional<Statement> getFinalBody() {
        return this.finalBody;
    }

    public void setFinalBody(Optional<Statement> finalBody) {
        this.finalBody = finalBody;
        this.setParentToFinalBody();
    }

    public Statement addStatement(Statement statement) {
        if (this.body == null) {
            this.body = statement;
            return statement;
        }
        this.body = this.transformStmtToBody();
        Body body = (Body)this.body;
        body.addStatement(statement);
        return statement;
    }

    public ExceptHandler addHandlerWithBody(ExceptHandler handler, Statement handlerBody) {
        this.handlers.add(handler);
        this.handlersBody.add(handlerBody);
        this.setParentToHandlersBody();
        return handler;
    }

    public Statement addStatementToHandler(ExceptHandler handler, Statement statement) {
        if (!this.handlers.contains(handler)) {
            throw new NoSuchElementException("Handler does not exist in attribute 'handlers'.");
        }
        int indexOfHandler = this.handlers.indexOf(handler);
        if (this.handlersBody.get(indexOfHandler) instanceof Body) {
            Body body = (Body)this.handlersBody.get(indexOfHandler);
            body.addStatement(statement);
        } else {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add(this.handlersBody.get(indexOfHandler));
            statements.add(statement);
            Body body = new Body(statements);
            body.setParentStmt(this);
            this.handlersBody.remove(indexOfHandler);
            this.handlersBody.add(indexOfHandler, body);
        }
        return statement;
    }

    private Body transformStmtToBody() {
        if (this.body instanceof Body) {
            return (Body)this.body;
        }
        Statement statement = this.body;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(statement);
        Body body = new Body(statements);
        body.setParentStmt(this);
        return body;
    }

    private void setParentToBodies() {
        this.setParentToBody();
        this.setParentToHandlersBody();
        this.setParentToOrElse();
        this.setParentToFinalBody();
    }

    private void setParentToBody() {
        if (this.body instanceof Body) {
            ((Body)this.body).setParentStmt(this);
        }
    }

    private void setParentToHandlersBody() {
        if (this.handlersBody == null) {
            return;
        }
        for (Statement body : this.handlersBody) {
            if (!(body instanceof Body)) continue;
            ((Body)body).setParentStmt(this);
        }
    }

    private void setParentToOrElse() {
        Statement orElseStmt;
        if (this.orElse.isPresent() && (orElseStmt = this.orElse.get()) instanceof Body) {
            ((Body)orElseStmt).setParentStmt(this);
        }
    }

    private void setParentToFinalBody() {
        Statement finalStmt;
        if (this.finalBody.isPresent() && (finalStmt = this.finalBody.get()) instanceof Body) {
            ((Body)finalStmt).setParentStmt(this);
        }
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitTry(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Try aTry = (Try)o;
        return Objects.equals(this.body, aTry.body) && Objects.equals(this.handlers, aTry.handlers) && Objects.equals(this.handlersBody, aTry.handlersBody) && Objects.equals(this.orElse, aTry.orElse) && Objects.equals(this.finalBody, aTry.finalBody);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.handlers, this.handlersBody, this.orElse, this.finalBody);
    }

    public String toString() {
        return "Try";
    }
}

