/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.utilities;

import io.github.danielnaczo.python3parser.Python3Lexer;
import io.github.danielnaczo.python3parser.Python3Parser;
import io.github.danielnaczo.python3parser.model.mods.ExpressionMod;
import io.github.danielnaczo.python3parser.model.mods.Interactive;
import io.github.danielnaczo.python3parser.model.mods.Module;
import io.github.danielnaczo.python3parser.visitors.ast.ModuleVisitor;
import io.github.danielnaczo.python3parser.visitors.prettyprint.IndentationPrettyPrint;
import io.github.danielnaczo.python3parser.visitors.prettyprint.ModulePrettyPrintVisitor;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class ASTParser {
    public static Module parseModuleWithCode(String python3Code) {
        CodePointCharStream charStream = CharStreams.fromString((String)python3Code);
        Python3Lexer lexer = new Python3Lexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        Module module = (Module)moduleVisitor.visit((ParseTree)parser.file_input());
        return module;
    }

    public static ExpressionMod parseExpressionModWithCode(String python3Code) {
        CodePointCharStream charStream = CharStreams.fromString((String)python3Code);
        Python3Lexer lexer = new Python3Lexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        ExpressionMod expressionMod = (ExpressionMod)moduleVisitor.visit((ParseTree)parser.eval_input());
        return expressionMod;
    }

    public static Interactive parseInteractiveWithCode(String python3Code) {
        CodePointCharStream charStream = CharStreams.fromString((String)python3Code);
        Python3Lexer lexer = new Python3Lexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        Interactive interactive = (Interactive)moduleVisitor.visit((ParseTree)parser.single_input());
        return interactive;
    }

    public static Module parseModuleWithFile(String pathToPython3File) throws Exception {
        CharStream charStream = CharStreams.fromFileName((String)pathToPython3File);
        Python3Lexer lexer = new Python3Lexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        Module module = (Module)moduleVisitor.visit((ParseTree)parser.file_input());
        return module;
    }

    public static ExpressionMod parseExpressionModWithFile(String pathToPython3File) throws Exception {
        CharStream charStream = CharStreams.fromFileName((String)pathToPython3File);
        Python3Lexer lexer = new Python3Lexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        ExpressionMod expressionMod = (ExpressionMod)moduleVisitor.visit((ParseTree)parser.eval_input());
        return expressionMod;
    }

    public static Interactive parseInteractiveWithFile(String pathToPython3File) throws Exception {
        CharStream charStream = CharStreams.fromFileName((String)pathToPython3File);
        Python3Lexer lexer = new Python3Lexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        Interactive interactive = (Interactive)moduleVisitor.visit((ParseTree)parser.single_input());
        return interactive;
    }

    public static Module cloneModule(Module ast) {
        ModulePrettyPrintVisitor modulePrettyPrintVisitor = new ModulePrettyPrintVisitor();
        String prettyprintedString = modulePrettyPrintVisitor.visitModule(ast, new IndentationPrettyPrint(0));
        CodePointCharStream charStream = CharStreams.fromString((String)prettyprintedString);
        Python3Lexer lexer = new Python3Lexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        return (Module)moduleVisitor.visitFile_input(parser.file_input());
    }

    public static ExpressionMod cloneExpressionMod(ExpressionMod ast) {
        ModulePrettyPrintVisitor modulePrettyPrintVisitor = new ModulePrettyPrintVisitor();
        String prettyprintedString = modulePrettyPrintVisitor.visitExpressionMod(ast, new IndentationPrettyPrint(0));
        CodePointCharStream charStream = CharStreams.fromString((String)prettyprintedString);
        Python3Lexer lexer = new Python3Lexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        return (ExpressionMod)moduleVisitor.visitEval_input(parser.eval_input());
    }

    public static Interactive cloneInteractive(Interactive ast) {
        ModulePrettyPrintVisitor modulePrettyPrintVisitor = new ModulePrettyPrintVisitor();
        String prettyprintedString = modulePrettyPrintVisitor.visitInteractive(ast, new IndentationPrettyPrint(0));
        CodePointCharStream charStream = CharStreams.fromString((String)prettyprintedString);
        Python3Lexer lexer = new Python3Lexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        return (Interactive)moduleVisitor.visitSingle_input(parser.single_input());
    }
}

