/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.visitors.ast;

import io.github.danielnaczo.python3parser.Python3Parser;
import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.subscripts.Index;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.subscripts.slices.Slice;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.subscripts.slices.SliceAbstract;
import io.github.danielnaczo.python3parser.visitors.ast.ExpressionVisitor;
import io.github.danielnaczo.python3parser.visitors.ast.GenericUnsupportedCSTVisitor;
import io.github.danielnaczo.python3parser.visitors.exceptions.RuleException;

public class SliceVisitor
extends GenericUnsupportedCSTVisitor<SliceAbstract> {
    @Override
    public SliceAbstract visitSubscript(Python3Parser.SubscriptContext ctx) {
        if (ctx.subscriptIndex() != null) {
            return ctx.subscriptIndex().accept(new SliceVisitor());
        }
        if (ctx.subscriptSlice() != null) {
            return ctx.subscriptSlice().accept(new SliceVisitor());
        }
        throw new RuleException();
    }

    @Override
    public SliceAbstract visitSubscriptIndex(Python3Parser.SubscriptIndexContext ctx) {
        Expression value = ctx.test().accept(new ExpressionVisitor());
        return new Index(value);
    }

    @Override
    public SliceAbstract visitSubscriptSlice(Python3Parser.SubscriptSliceContext ctx) {
        Expression lower = ctx.slicelLower().accept(new ExpressionVisitor());
        Expression upper = ctx.sliceUpper().accept(new ExpressionVisitor());
        Expression step = null;
        if (ctx.sliceStep() != null) {
            step = ctx.sliceStep().accept(new ExpressionVisitor());
        }
        return new Slice(lower, upper, step);
    }
}

