/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.visitors.ast;

import io.github.danielnaczo.python3parser.Python3Parser;
import io.github.danielnaczo.python3parser.model.Identifier;
import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.expr.ExpressionsList;
import io.github.danielnaczo.python3parser.model.expr.atoms.Atom;
import io.github.danielnaczo.python3parser.model.expr.atoms.Ellipsis;
import io.github.danielnaczo.python3parser.model.expr.atoms.False;
import io.github.danielnaczo.python3parser.model.expr.atoms.JoinedStr;
import io.github.danielnaczo.python3parser.model.expr.atoms.Name;
import io.github.danielnaczo.python3parser.model.expr.atoms.None;
import io.github.danielnaczo.python3parser.model.expr.atoms.Num;
import io.github.danielnaczo.python3parser.model.expr.atoms.Str;
import io.github.danielnaczo.python3parser.model.expr.atoms.True;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.Attribute;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.arguments.ArgumentComp;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.arguments.Arguments;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.arguments.Keyword;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.subscripts.Subscript;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.subscripts.slices.ExtSlice;
import io.github.danielnaczo.python3parser.model.expr.atoms.trailers.subscripts.slices.SliceAbstract;
import io.github.danielnaczo.python3parser.model.expr.comprehensions.Comprehension;
import io.github.danielnaczo.python3parser.model.expr.comprehensions.DictComp;
import io.github.danielnaczo.python3parser.model.expr.comprehensions.ListComp;
import io.github.danielnaczo.python3parser.model.expr.comprehensions.SetComp;
import io.github.danielnaczo.python3parser.model.expr.datastructures.Dict;
import io.github.danielnaczo.python3parser.model.expr.datastructures.ListExpr;
import io.github.danielnaczo.python3parser.model.expr.datastructures.Set;
import io.github.danielnaczo.python3parser.model.expr.datastructures.Tuple;
import io.github.danielnaczo.python3parser.model.expr.generators.Generator;
import io.github.danielnaczo.python3parser.model.expr.operators.IfExpr;
import io.github.danielnaczo.python3parser.model.expr.operators.Lambda;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.Add;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.At;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.BinOp;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.BitAnd;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.BitOr;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.BitXor;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.Div;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.FloorDiv;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.LShift;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.Mod;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.Mult;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.Pow;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.RShift;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.Sub;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.boolops.And;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.boolops.Or;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.Eq;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.Gt;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.GtE;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.In;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.Is;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.IsNot;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.Lt;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.LtE;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.NotEq;
import io.github.danielnaczo.python3parser.model.expr.operators.binaryops.comparisons.NotIn;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.Await;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.Invert;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.Not;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.Starred;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.UAdd;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.USub;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.UnaryOp;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.Yield;
import io.github.danielnaczo.python3parser.model.expr.operators.unaryops.YieldFrom;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.parameters.Parameters;
import io.github.danielnaczo.python3parser.visitors.ast.ComprehensionVisitor;
import io.github.danielnaczo.python3parser.visitors.ast.GenericUnsupportedCSTVisitor;
import io.github.danielnaczo.python3parser.visitors.ast.KeywordVisitor;
import io.github.danielnaczo.python3parser.visitors.ast.SliceVisitor;
import io.github.danielnaczo.python3parser.visitors.ast.parameters.ParametersVisitor;
import io.github.danielnaczo.python3parser.visitors.exceptions.RuleException;
import java.util.ArrayList;

public class ExpressionVisitor
extends GenericUnsupportedCSTVisitor<Expression> {
    @Override
    public Expression visitExpr_NormalAssignList(Python3Parser.Expr_NormalAssignListContext ctx) {
        if (ctx.yield_expr() != null) {
            return ctx.yield_expr().accept(new ExpressionVisitor());
        }
        if (ctx.testlist_star_expr() != null) {
            return ctx.testlist_star_expr().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTestlist_star_expr(Python3Parser.Testlist_star_exprContext ctx) {
        if (ctx.testOrStarList_expr() == null || ctx.testOrStarList_expr().isEmpty()) {
            return ctx.testOrStar_expr().accept(new ExpressionVisitor());
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(ctx.testOrStar_expr().accept(new ExpressionVisitor()));
        for (int i = 0; i < ctx.testOrStarList_expr().size(); ++i) {
            expressions.add(ctx.testOrStarList_expr(i).accept(new ExpressionVisitor()));
        }
        return new ExpressionsList(expressions);
    }

    @Override
    public Expression visitTestOrStar_expr(Python3Parser.TestOrStar_exprContext ctx) {
        if (ctx.test() != null) {
            return ctx.test().accept(new ExpressionVisitor());
        }
        if (ctx.star_expr() != null) {
            return ctx.star_expr().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTestOrStarList_expr(Python3Parser.TestOrStarList_exprContext ctx) {
        if (ctx.test() != null) {
            return ctx.test().accept(new ExpressionVisitor());
        }
        if (ctx.star_expr() != null) {
            return ctx.star_expr().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTest(Python3Parser.TestContext ctx) {
        if (ctx.or_test() != null && !ctx.or_test().isEmpty()) {
            if (ctx.or_test().size() == 1) {
                return ctx.or_test(0).accept(new ExpressionVisitor());
            }
            if (ctx.or_test().size() == 2) {
                Expression test = ctx.or_test(1).accept(new ExpressionVisitor());
                Expression body = ctx.or_test(0).accept(new ExpressionVisitor());
                Expression orElse = ctx.test().accept(new ExpressionVisitor());
                IfExpr ifExpr = new IfExpr(test, body, orElse);
                test.setParent(ifExpr);
                body.setParent(ifExpr);
                orElse.setParent(ifExpr);
                return ifExpr;
            }
        }
        if (!ctx.lambdef().isEmpty()) {
            return ctx.lambdef().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTest_nocond(Python3Parser.Test_nocondContext ctx) {
        if (ctx.or_test() != null) {
            return ctx.or_test().accept(new ExpressionVisitor());
        }
        if (ctx.lambdef_nocond() != null) {
            return ctx.lambdef_nocond().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitLambdef(Python3Parser.LambdefContext ctx) {
        Parameters args = null;
        if (ctx.varargslist() != null) {
            args = ctx.varargslist().accept(new ParametersVisitor());
        }
        Expression body = ctx.test().accept(new ExpressionVisitor());
        Lambda lambda = new Lambda(args, body);
        body.setParent(lambda);
        return lambda;
    }

    @Override
    public Expression visitLambdef_nocond(Python3Parser.Lambdef_nocondContext ctx) {
        Parameters args = null;
        if (ctx.varargslist() != null) {
            args = ctx.varargslist().accept(new ParametersVisitor());
        }
        Expression body = ctx.test_nocond().accept(new ExpressionVisitor());
        return new Lambda(args, body);
    }

    @Override
    public Expression visitOr_test(Python3Parser.Or_testContext ctx) {
        if (ctx.and_test().size() == 1) {
            return ctx.and_test(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.and_test(0).accept(new ExpressionVisitor());
        Expression right = ctx.and_test(1).accept(new ExpressionVisitor());
        Or binOp = new Or(left, right);
        left.setParent(binOp);
        right.setParent(binOp);
        for (int i = 2; i < ctx.and_test().size(); ++i) {
            left = binOp;
            right = ctx.and_test(i).accept(new ExpressionVisitor());
            binOp = new Or(left, right);
            left.setParent(binOp);
            right.setParent(binOp);
        }
        return binOp;
    }

    @Override
    public Expression visitAnd_test(Python3Parser.And_testContext ctx) {
        if (ctx.not_test().size() == 1) {
            return ctx.not_test(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.not_test(0).accept(new ExpressionVisitor());
        Expression right = ctx.not_test(1).accept(new ExpressionVisitor());
        And binOp = new And(left, right);
        left.setParent(binOp);
        right.setParent(binOp);
        for (int i = 2; i < ctx.not_test().size(); ++i) {
            left = binOp;
            right = ctx.not_test(i).accept(new ExpressionVisitor());
            binOp = new And(left, right);
            left.setParent(binOp);
            right.setParent(binOp);
        }
        return binOp;
    }

    @Override
    public Expression visitNot_test(Python3Parser.Not_testContext ctx) {
        if (ctx.not_test() != null) {
            Expression expression = ctx.not_test().accept(new ExpressionVisitor());
            Not unaryOp = new Not(expression);
            expression.setParent(unaryOp);
            return unaryOp;
        }
        if (ctx.comparison() != null) {
            return ctx.comparison().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitComparison(Python3Parser.ComparisonContext ctx) {
        if (ctx.expr().size() == 1) {
            return ctx.expr(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.expr(0).accept(new ExpressionVisitor());
        Expression right = ctx.expr(1).accept(new ExpressionVisitor());
        BinOp binOp = this.createComparisonExpr(left, ctx.comp_op(0), right);
        for (int i = 2; i < ctx.expr().size(); ++i) {
            left = binOp;
            right = ctx.expr(i).accept(new ExpressionVisitor());
            binOp = this.createComparisonExpr(left, ctx.comp_op(i - 1), right);
        }
        return binOp;
    }

    private BinOp createComparisonExpr(Expression left, Python3Parser.Comp_opContext compOp, Expression right) {
        if (compOp.NOT() != null && compOp.IN() != null) {
            NotIn notIn = new NotIn(left, right);
            left.setParent(notIn);
            right.setParent(notIn);
            return notIn;
        }
        if (compOp.IS() != null && compOp.NOT() != null) {
            IsNot isNot = new IsNot(left, right);
            left.setParent(isNot);
            right.setParent(isNot);
            return isNot;
        }
        if (compOp.LESS_THAN() != null) {
            Lt lt = new Lt(left, right);
            left.setParent(lt);
            right.setParent(lt);
            return lt;
        }
        if (compOp.GREATER_THAN() != null) {
            Gt gt = new Gt(left, right);
            left.setParent(gt);
            right.setParent(gt);
            return gt;
        }
        if (compOp.EQUALS() != null) {
            Eq eq = new Eq(left, right);
            left.setParent(eq);
            right.setParent(eq);
            return eq;
        }
        if (compOp.GT_EQ() != null) {
            GtE gte = new GtE(left, right);
            left.setParent(gte);
            right.setParent(gte);
            return gte;
        }
        if (compOp.LT_EQ() != null) {
            LtE lte = new LtE(left, right);
            left.setParent(lte);
            right.setParent(lte);
            return lte;
        }
        if (compOp.NOT_EQ_1() != null) {
            NotEq notEq = new NotEq(left, right);
            left.setParent(notEq);
            right.setParent(notEq);
            return notEq;
        }
        if (compOp.NOT_EQ_2() != null) {
            NotEq notEq = new NotEq(left, right);
            left.setParent(notEq);
            right.setParent(notEq);
            return notEq;
        }
        if (compOp.IN() != null) {
            In in = new In(left, right);
            left.setParent(in);
            right.setParent(in);
            return in;
        }
        if (compOp.IS() != null) {
            Is is = new Is(left, right);
            left.setParent(is);
            right.setParent(is);
            return is;
        }
        throw new RuleException();
    }

    @Override
    public Expression visitStar_expr(Python3Parser.Star_exprContext ctx) {
        Expression expression = ctx.expr().accept(new ExpressionVisitor());
        Starred unaryOp = new Starred(expression);
        expression.setParent(unaryOp);
        return unaryOp;
    }

    @Override
    public Expression visitExpr(Python3Parser.ExprContext ctx) {
        if (ctx.xor_expr().size() == 1) {
            return ctx.xor_expr(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.xor_expr(0).accept(new ExpressionVisitor());
        Expression right = ctx.xor_expr(1).accept(new ExpressionVisitor());
        BitOr binOp = new BitOr(left, right);
        left.setParent(binOp);
        right.setParent(binOp);
        for (int i = 2; i < ctx.xor_expr().size(); ++i) {
            left = binOp;
            right = ctx.xor_expr(i).accept(new ExpressionVisitor());
            binOp = new BitOr(left, right);
            left.setParent(binOp);
            right.setParent(binOp);
        }
        return binOp;
    }

    @Override
    public Expression visitXor_expr(Python3Parser.Xor_exprContext ctx) {
        if (ctx.and_expr().size() == 1) {
            return ctx.and_expr(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.and_expr(0).accept(new ExpressionVisitor());
        Expression right = ctx.and_expr(1).accept(new ExpressionVisitor());
        BitXor binOp = new BitXor(left, right);
        left.setParent(binOp);
        right.setParent(binOp);
        for (int i = 2; i < ctx.and_expr().size(); ++i) {
            left = binOp;
            right = ctx.and_expr(i).accept(new ExpressionVisitor());
            binOp = new BitXor(left, right);
            left.setParent(binOp);
            right.setParent(binOp);
        }
        return binOp;
    }

    @Override
    public Expression visitAnd_expr(Python3Parser.And_exprContext ctx) {
        if (ctx.shift_expr().size() == 1) {
            return ctx.shift_expr(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.shift_expr(0).accept(new ExpressionVisitor());
        Expression right = ctx.shift_expr(1).accept(new ExpressionVisitor());
        BitAnd binOp = new BitAnd(left, right);
        left.setParent(binOp);
        right.setParent(binOp);
        for (int i = 2; i < ctx.shift_expr().size(); ++i) {
            left = binOp;
            right = ctx.shift_expr(i).accept(new ExpressionVisitor());
            binOp = new BitAnd(left, right);
            left.setParent(binOp);
            right.setParent(binOp);
        }
        return binOp;
    }

    @Override
    public Expression visitShift_expr(Python3Parser.Shift_exprContext ctx) {
        if (ctx.arith_expr().size() == 1) {
            return ctx.arith_expr(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.arith_expr(0).accept(new ExpressionVisitor());
        Expression right = ctx.arith_expr(1).accept(new ExpressionVisitor());
        BinOp binOp = this.createShiftExpr(left, ctx.shift_op(0), right);
        for (int i = 2; i < ctx.arith_expr().size(); ++i) {
            left = binOp;
            right = ctx.arith_expr(i).accept(new ExpressionVisitor());
            binOp = this.createShiftExpr(left, ctx.shift_op(i - 1), right);
        }
        return binOp;
    }

    private BinOp createShiftExpr(Expression left, Python3Parser.Shift_opContext shiftOp, Expression right) {
        if (shiftOp.LEFT_SHIFT() != null) {
            LShift lShift = new LShift(left, right);
            left.setParent(lShift);
            right.setParent(lShift);
            return lShift;
        }
        if (shiftOp.RIGHT_SHIFT() != null) {
            RShift rShift = new RShift(left, right);
            left.setParent(rShift);
            right.setParent(rShift);
            return rShift;
        }
        throw new RuleException();
    }

    @Override
    public Expression visitArith_expr(Python3Parser.Arith_exprContext ctx) {
        if (ctx.term().size() == 1) {
            return ctx.term(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.term(0).accept(new ExpressionVisitor());
        Expression right = ctx.term(1).accept(new ExpressionVisitor());
        BinOp binOp = this.createArithExpr(left, ctx.arith_op(0), right);
        for (int i = 2; i < ctx.term().size(); ++i) {
            left = binOp;
            right = ctx.term(i).accept(new ExpressionVisitor());
            binOp = this.createArithExpr(left, ctx.arith_op(i - 1), right);
        }
        return binOp;
    }

    private BinOp createArithExpr(Expression left, Python3Parser.Arith_opContext arithOp, Expression right) {
        if (arithOp.ADD() != null) {
            Add add = new Add(left, right);
            left.setParent(add);
            right.setParent(add);
            return add;
        }
        if (arithOp.MINUS() != null) {
            Sub sub = new Sub(left, right);
            left.setParent(sub);
            right.setParent(sub);
            return sub;
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTerm(Python3Parser.TermContext ctx) {
        if (ctx.factor().size() == 1) {
            return ctx.factor(0).accept(new ExpressionVisitor());
        }
        Expression left = ctx.factor(0).accept(new ExpressionVisitor());
        Expression right = ctx.factor(1).accept(new ExpressionVisitor());
        BinOp binOp = this.createTerm(left, ctx.term_op(0), right);
        for (int i = 2; i < ctx.factor().size(); ++i) {
            left = binOp;
            right = ctx.factor(i).accept(new ExpressionVisitor());
            binOp = this.createTerm(left, ctx.term_op(i - 1), right);
        }
        return binOp;
    }

    private BinOp createTerm(Expression left, Python3Parser.Term_opContext termOp, Expression right) {
        if (termOp.STAR() != null) {
            Mult mult = new Mult(left, right);
            left.setParent(mult);
            right.setParent(mult);
            return mult;
        }
        if (termOp.AT() != null) {
            At at = new At(left, right);
            left.setParent(at);
            right.setParent(at);
            return at;
        }
        if (termOp.DIV() != null) {
            Div div = new Div(left, right);
            left.setParent(div);
            right.setParent(div);
            return div;
        }
        if (termOp.MOD() != null) {
            Mod mod = new Mod(left, right);
            left.setParent(mod);
            right.setParent(mod);
            return mod;
        }
        if (termOp.IDIV() != null) {
            FloorDiv floorDiv = new FloorDiv(left, right);
            left.setParent(floorDiv);
            right.setParent(floorDiv);
            return floorDiv;
        }
        throw new RuleException();
    }

    @Override
    public Expression visitFactor(Python3Parser.FactorContext ctx) {
        if (ctx.factor_op() != null && ctx.factor() != null) {
            Expression expression = ctx.factor().accept(new ExpressionVisitor());
            UnaryOp unaryOp = this.createUnaryOpExpr(expression, ctx.factor_op());
            return unaryOp;
        }
        if (ctx.power() != null) {
            return ctx.power().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    private UnaryOp createUnaryOpExpr(Expression expression, Python3Parser.Factor_opContext factorOp) {
        if (factorOp.ADD() != null) {
            UAdd uAdd = new UAdd(expression);
            expression.setParent(uAdd);
            return uAdd;
        }
        if (factorOp.MINUS() != null) {
            USub uSub = new USub(expression);
            expression.setParent(uSub);
            return uSub;
        }
        if (factorOp.NOT_OP() != null) {
            Invert invert = new Invert(expression);
            expression.setParent(invert);
            return invert;
        }
        throw new RuleException();
    }

    @Override
    public Expression visitPower(Python3Parser.PowerContext ctx) {
        if (ctx.factor() != null) {
            Expression left = ctx.await().accept(new ExpressionVisitor());
            Expression right = ctx.factor().accept(new ExpressionVisitor());
            Pow pow = new Pow(left, right);
            left.setParent(pow);
            right.setParent(pow);
            return pow;
        }
        return ctx.await().accept(new ExpressionVisitor());
    }

    @Override
    public Expression visitAwait(Python3Parser.AwaitContext ctx) {
        if (ctx.AWAIT() != null) {
            Expression expression = ctx.atom_expr().accept(new ExpressionVisitor());
            Await await = new Await(expression);
            expression.setParent(await);
            return await;
        }
        return ctx.atom_expr().accept(new ExpressionVisitor());
    }

    @Override
    public Expression visitAtom_expr(Python3Parser.Atom_exprContext ctx) {
        if (ctx.test() != null) {
            return ctx.test().accept(new ExpressionVisitor());
        }
        if (ctx.trailer() == null || ctx.trailer().isEmpty()) {
            Expression expression = ctx.atom().accept(new ExpressionVisitor());
            return expression;
        }
        Expression atomElement = ctx.atom().accept(new ExpressionVisitor());
        ArrayList<Expression> trailers = new ArrayList<Expression>();
        for (int i = 0; i < ctx.trailer().size(); ++i) {
            trailers.add(ctx.trailer(i).accept(new ExpressionVisitor()));
        }
        return new Atom(atomElement, trailers);
    }

    @Override
    public Expression visitTrailer(Python3Parser.TrailerContext ctx) {
        if (ctx.trailerCall() != null) {
            return ctx.trailerCall().accept(new ExpressionVisitor());
        }
        if (ctx.trailerSubscript() != null) {
            return ctx.trailerSubscript().accept(new ExpressionVisitor());
        }
        if (ctx.trailerName() != null) {
            return ctx.trailerName().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTrailerCall(Python3Parser.TrailerCallContext ctx) {
        if (ctx.arglist() != null) {
            return ctx.arglist().accept(new ExpressionVisitor());
        }
        return new Arguments(null, null, null, null);
    }

    @Override
    public Expression visitTrailerSubscript(Python3Parser.TrailerSubscriptContext ctx) {
        return ctx.subscriptlist().accept(new ExpressionVisitor());
    }

    @Override
    public Expression visitTrailerName(Python3Parser.TrailerNameContext ctx) {
        Identifier attr = new Identifier(ctx.NAME().getText());
        return new Attribute(attr);
    }

    @Override
    public Expression visitAtom(Python3Parser.AtomContext ctx) {
        if (ctx.tuple() != null) {
            return ctx.tuple().accept(new ExpressionVisitor());
        }
        if (ctx.list() != null) {
            return ctx.list().accept(new ExpressionVisitor());
        }
        if (ctx.dictionaryOrSet() != null) {
            return ctx.dictionaryOrSet().accept(new ExpressionVisitor());
        }
        if (ctx.NAME() != null) {
            return new Name(new Identifier(ctx.NAME().getText()));
        }
        if (ctx.NUMBER() != null) {
            return new Num(ctx.NUMBER().getText());
        }
        if (ctx.STRING() != null && !ctx.STRING().isEmpty()) {
            if (ctx.STRING().size() == 1) {
                return new Str(ctx.STRING(0).getText());
            }
            ArrayList<Expression> strings = new ArrayList<Expression>();
            for (int i = 0; i < ctx.STRING().size(); ++i) {
                strings.add(new Str(ctx.STRING(i).getText()));
            }
            return new JoinedStr(strings);
        }
        if (ctx.ELLIPSIS() != null) {
            return new Ellipsis();
        }
        if (ctx.NONE() != null) {
            return new None();
        }
        if (ctx.TRUE() != null) {
            return new True();
        }
        if (ctx.FALSE() != null) {
            return new False();
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTuple(Python3Parser.TupleContext ctx) {
        if (ctx.testlist_compTuple() == null) {
            return new Tuple(null);
        }
        if (ctx.testlist_compTuple() != null) {
            return ctx.testlist_compTuple().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTestlist_compTuple(Python3Parser.Testlist_compTupleContext ctx) {
        if (ctx.yield_expr() != null) {
            Expression elt = ctx.yield_expr().accept(new ExpressionVisitor());
            return new Generator(elt, null);
        }
        if (ctx.comp_for() != null && !ctx.comp_for().isEmpty()) {
            Expression elt = ctx.testOrStar_expr().accept(new ExpressionVisitor());
            ArrayList<Comprehension> generators = new ArrayList<Comprehension>();
            for (int i = 0; i < ctx.comp_for().size(); ++i) {
                generators.add(ctx.comp_for(i).accept(new ComprehensionVisitor()));
            }
            return new Generator(elt, generators);
        }
        ArrayList<Expression> elts = new ArrayList<Expression>();
        elts.add(ctx.testOrStar_expr().accept(new ExpressionVisitor()));
        for (int i = 0; i < ctx.testOrStarList_expr().size(); ++i) {
            elts.add(ctx.testOrStarList_expr(i).accept(new ExpressionVisitor()));
        }
        return new Tuple(elts);
    }

    @Override
    public Expression visitList(Python3Parser.ListContext ctx) {
        if (ctx.testlist_compList() == null) {
            return new ListExpr(null);
        }
        return ctx.testlist_compList().accept(new ExpressionVisitor());
    }

    @Override
    public Expression visitTestlist_compList(Python3Parser.Testlist_compListContext ctx) {
        if (ctx.comp_for() != null && !ctx.comp_for().isEmpty()) {
            Expression elt = ctx.testOrStar_expr().accept(new ExpressionVisitor());
            ArrayList<Comprehension> comprehensions = new ArrayList<Comprehension>();
            for (int i = 0; i < ctx.comp_for().size(); ++i) {
                comprehensions.add(ctx.comp_for(i).accept(new ComprehensionVisitor()));
            }
            return new ListComp(elt, comprehensions);
        }
        ArrayList<Expression> elts = new ArrayList<Expression>();
        elts.add(ctx.testOrStar_expr().accept(new ExpressionVisitor()));
        for (int i = 0; i < ctx.testOrStarList_expr().size(); ++i) {
            elts.add(ctx.testOrStarList_expr(i).accept(new ExpressionVisitor()));
        }
        return new ListExpr(elts);
    }

    @Override
    public Expression visitDictionaryOrSet(Python3Parser.DictionaryOrSetContext ctx) {
        if (ctx.dictorsetmaker() == null) {
            return new Dict(null, null);
        }
        return ctx.dictorsetmaker().accept(new ExpressionVisitor());
    }

    @Override
    public Expression visitDictorsetmaker(Python3Parser.DictorsetmakerContext ctx) {
        if (ctx.dictFirst() != null) {
            if ((ctx.comp_for() == null || ctx.comp_for().isEmpty()) && (ctx.dicts() == null || ctx.dicts().isEmpty())) {
                return ctx.dictFirst().accept(new ExpressionVisitor());
            }
            if (ctx.comp_for() != null && !ctx.comp_for().isEmpty()) {
                Expression key = null;
                Expression value = null;
                ArrayList<Comprehension> comprehensions = new ArrayList<Comprehension>();
                if (ctx.dictFirst().test() != null && !ctx.dictFirst().test().isEmpty()) {
                    key = ctx.dictFirst().test(0).accept(new ExpressionVisitor());
                    value = ctx.dictFirst().test(1).accept(new ExpressionVisitor());
                } else if (ctx.dictFirst().expr() != null) {
                    key = null;
                    value = ctx.dictFirst().expr().accept(new ExpressionVisitor());
                }
                for (int i = 0; i < ctx.comp_for().size(); ++i) {
                    comprehensions.add(ctx.comp_for(i).accept(new ComprehensionVisitor()));
                }
                return new DictComp(key, value, comprehensions);
            }
            if (ctx.dicts() != null && !ctx.dicts().isEmpty()) {
                ArrayList<Expression> keys = new ArrayList<Expression>();
                ArrayList<Expression> values = new ArrayList<Expression>();
                if (ctx.dictFirst().test() != null && !ctx.dictFirst().test().isEmpty()) {
                    keys.add(ctx.dictFirst().test(0).accept(new ExpressionVisitor()));
                    values.add(ctx.dictFirst().test(1).accept(new ExpressionVisitor()));
                }
                if (ctx.dictFirst().expr() != null) {
                    keys.add(null);
                    values.add(ctx.dictFirst().expr().accept(new ExpressionVisitor()));
                }
                for (int i = 0; i < ctx.dicts().size(); ++i) {
                    if (ctx.dicts(i).test() != null && !ctx.dicts(i).test().isEmpty()) {
                        keys.add(ctx.dicts(i).test(0).accept(new ExpressionVisitor()));
                        values.add(ctx.dicts(i).test(1).accept(new ExpressionVisitor()));
                        continue;
                    }
                    if (ctx.dicts(i).expr() == null) continue;
                    keys.add(null);
                    values.add(ctx.dicts(i).expr().accept(new ExpressionVisitor()));
                }
                return new Dict(keys, values);
            }
        }
        if (ctx.setFirst() != null) {
            if ((ctx.comp_for() == null || ctx.comp_for().isEmpty()) && (ctx.sets() == null || ctx.sets().isEmpty())) {
                return ctx.setFirst().accept(new ExpressionVisitor());
            }
            if (ctx.comp_for() != null && !ctx.comp_for().isEmpty()) {
                Expression elt = null;
                ArrayList<Comprehension> comprehensions = new ArrayList<Comprehension>();
                if (ctx.setFirst().test() != null) {
                    elt = ctx.setFirst().test().accept(new ExpressionVisitor());
                } else if (ctx.setFirst().star_expr() != null) {
                    elt = ctx.setFirst().star_expr().accept(new ExpressionVisitor());
                }
                for (int i = 0; i < ctx.comp_for().size(); ++i) {
                    comprehensions.add(ctx.comp_for(i).accept(new ComprehensionVisitor()));
                }
                return new SetComp(elt, comprehensions);
            }
            if (ctx.sets() != null && !ctx.sets().isEmpty()) {
                ArrayList<Expression> elts = new ArrayList<Expression>();
                if (ctx.setFirst().test() != null) {
                    elts.add(ctx.setFirst().test().accept(new ExpressionVisitor()));
                }
                if (ctx.setFirst().star_expr() != null) {
                    elts.add(ctx.setFirst().star_expr().accept(new ExpressionVisitor()));
                }
                for (int i = 0; i < ctx.sets().size(); ++i) {
                    if (ctx.sets(i).test() != null) {
                        elts.add(ctx.sets(i).test().accept(new ExpressionVisitor()));
                        continue;
                    }
                    if (ctx.sets(i).star_expr() == null) continue;
                    elts.add(ctx.sets(i).star_expr().accept(new ExpressionVisitor()));
                }
                return new Set(elts);
            }
        }
        throw new RuleException();
    }

    @Override
    public Expression visitDictFirst(Python3Parser.DictFirstContext ctx) {
        ArrayList<Expression> keys = new ArrayList<Expression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        if (ctx.test() != null && !ctx.test().isEmpty()) {
            keys.add(ctx.test(0).accept(new ExpressionVisitor()));
            values.add(ctx.test(1).accept(new ExpressionVisitor()));
        }
        if (ctx.expr() != null) {
            keys.add(null);
            values.add(ctx.expr().accept(new ExpressionVisitor()));
        }
        return new Dict(keys, values);
    }

    @Override
    public Expression visitSetFirst(Python3Parser.SetFirstContext ctx) {
        ArrayList<Expression> elts = new ArrayList<Expression>();
        if (ctx.test() != null) {
            elts.add(ctx.test().accept(new ExpressionVisitor()));
        }
        if (ctx.star_expr() != null) {
            elts.add(ctx.star_expr().accept(new ExpressionVisitor()));
        }
        return new Set(elts);
    }

    @Override
    public Expression visitExprlist(Python3Parser.ExprlistContext ctx) {
        if (ctx.exprOrStarExpr().size() == 1) {
            return ctx.exprOrStarExpr(0).accept(new ExpressionVisitor());
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (int i = 0; i < ctx.exprOrStarExpr().size(); ++i) {
            expressions.add(ctx.exprOrStarExpr(i).accept(new ExpressionVisitor()));
        }
        return new ExpressionsList(expressions);
    }

    @Override
    public Expression visitExprOrStarExpr(Python3Parser.ExprOrStarExprContext ctx) {
        if (ctx.expr() != null) {
            return ctx.expr().accept(new ExpressionVisitor());
        }
        if (ctx.star_expr() != null) {
            return ctx.star_expr().accept(new ExpressionVisitor());
        }
        throw new RuleException();
    }

    @Override
    public Expression visitTestlist(Python3Parser.TestlistContext ctx) {
        if (ctx.test().size() == 1) {
            return ctx.test(0).accept(new ExpressionVisitor());
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (int i = 0; i < ctx.test().size(); ++i) {
            expressions.add(ctx.test(i).accept(new ExpressionVisitor()));
        }
        return new ExpressionsList(expressions);
    }

    @Override
    public Expression visitSubscriptlist(Python3Parser.SubscriptlistContext ctx) {
        SliceAbstract slice;
        if (ctx.subscript().size() == 1) {
            slice = ctx.subscript(0).accept(new SliceVisitor());
        } else {
            ArrayList<SliceAbstract> dims = new ArrayList<SliceAbstract>();
            for (int i = 0; i < ctx.subscript().size(); ++i) {
                dims.add(ctx.subscript(i).accept(new SliceVisitor()));
            }
            slice = new ExtSlice(dims);
        }
        return new Subscript(slice);
    }

    @Override
    public Expression visitSlicelLower(Python3Parser.SlicelLowerContext ctx) {
        if (ctx.test() != null) {
            return ctx.test().accept(new ExpressionVisitor());
        }
        return null;
    }

    @Override
    public Expression visitSliceUpper(Python3Parser.SliceUpperContext ctx) {
        if (ctx.test() != null) {
            return ctx.test().accept(new ExpressionVisitor());
        }
        return null;
    }

    @Override
    public Expression visitSliceStep(Python3Parser.SliceStepContext ctx) {
        if (ctx.test() != null) {
            return ctx.test().accept(new ExpressionVisitor());
        }
        return null;
    }

    @Override
    public Expression visitArglist(Python3Parser.ArglistContext ctx) {
        ArrayList<Expression> args = new ArrayList<Expression>();
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        ArrayList<Expression> starredArgs = new ArrayList<Expression>();
        ArrayList<Keyword> doubleStarredArgs = new ArrayList<Keyword>();
        for (int i = 0; i < ctx.argument().size(); ++i) {
            Python3Parser.ArgumentContext argumentContext = ctx.argument(i);
            if (argumentContext.argumentNormal() != null) {
                args.add(argumentContext.argumentNormal().accept(new ExpressionVisitor()));
            }
            if (argumentContext.argumentKeyword() != null) {
                keywords.add(argumentContext.argumentKeyword().accept(new KeywordVisitor()));
            }
            if (argumentContext.argumentStar() != null) {
                starredArgs.add(argumentContext.argumentStar().accept(new ExpressionVisitor()));
            }
            if (argumentContext.argumentDoubleStar() == null) continue;
            doubleStarredArgs.add(argumentContext.argumentDoubleStar().accept(new KeywordVisitor()));
        }
        return new Arguments(args, keywords, starredArgs, doubleStarredArgs);
    }

    @Override
    public Expression visitArgumentNormal(Python3Parser.ArgumentNormalContext ctx) {
        if (ctx.comp_for() == null || ctx.comp_for().isEmpty()) {
            return ctx.test().accept(new ExpressionVisitor());
        }
        Expression elt = ctx.test().accept(new ExpressionVisitor());
        ArrayList<Comprehension> comprehensions = new ArrayList<Comprehension>();
        for (int i = 0; i < ctx.comp_for().size(); ++i) {
            comprehensions.add(ctx.comp_for(i).accept(new ComprehensionVisitor()));
        }
        return new ArgumentComp(elt, comprehensions);
    }

    @Override
    public Expression visitArgumentStar(Python3Parser.ArgumentStarContext ctx) {
        return ctx.test().accept(new ExpressionVisitor());
    }

    @Override
    public Expression visitComp_if(Python3Parser.Comp_ifContext ctx) {
        return ctx.test_nocond().accept(new ExpressionVisitor());
    }

    @Override
    public Expression visitYield_expr(Python3Parser.Yield_exprContext ctx) {
        if (ctx.yield_arg() != null) {
            return ctx.yield_arg().accept(new ExpressionVisitor());
        }
        return new Yield(null);
    }

    @Override
    public Expression visitYield_arg(Python3Parser.Yield_argContext ctx) {
        if (ctx.test() != null) {
            Expression expression = ctx.test().accept(new ExpressionVisitor());
            YieldFrom yieldFrom = new YieldFrom(expression);
            expression.setParent(yieldFrom);
            return yieldFrom;
        }
        if (ctx.testlist() != null) {
            Expression expression = ctx.testlist().accept(new ExpressionVisitor());
            Yield yield = new Yield(expression);
            expression.setParent(yield);
            return yield;
        }
        throw new RuleException();
    }
}

