/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.devintest.api.resources.imdb;

import com.devintest.api.core.ClientOptions;
import com.devintest.api.core.RequestOptions;
import com.devintest.api.resources.imdb.types.CreateMovieRequest;
import com.devintest.api.resources.imdb.types.Movie;
import java.util.concurrent.CompletableFuture;

public class AsyncImdbClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawImdbClient rawClient;

    public AsyncImdbClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawImdbClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawImdbClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Add a movie to the database
     */
    public CompletableFuture<String> createMovie(CreateMovieRequest request) {
        return this.rawClient.createMovie(request).thenApply(response -> response.body());
    }

    /**
     * Add a movie to the database
     */
    public CompletableFuture<String> createMovie(CreateMovieRequest request, RequestOptions requestOptions) {
        return this.rawClient.createMovie(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieve a movie from the database based on the ID
     */
    public CompletableFuture<Movie> getMovie(String id) {
        return this.rawClient.getMovie(id).thenApply(response -> response.body());
    }

    /**
     * Retrieve a movie from the database based on the ID
     */
    public CompletableFuture<Movie> getMovie(String id, RequestOptions requestOptions) {
        return this.rawClient.getMovie(id, requestOptions).thenApply(response -> response.body());
    }
}
