/*
 * Decompiled with CFR 0.152.
 */
package com.devintest.api.core;

import com.devintest.api.core.DevintestApiException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Response;

public class DevintestApiApiException
extends DevintestApiException {
    private final int statusCode;
    private final Object body;
    private final Map<String, List<String>> headers;

    public DevintestApiApiException(String message, int statusCode, Object body) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
        this.headers = new HashMap<String, List<String>>();
    }

    public DevintestApiApiException(String message, int statusCode, Object body, Response rawResponse) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
        this.headers = new HashMap<String, List<String>>();
        rawResponse.headers().forEach(header -> {
            String key = (String)header.component1();
            String value = (String)header.component2();
            this.headers.computeIfAbsent(key, _str -> new ArrayList()).add(value);
        });
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Object body() {
        return this.body;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public String toString() {
        return "DevintestApiApiException{message: " + this.getMessage() + ", statusCode: " + this.statusCode + ", body: " + this.body + "}";
    }
}

