/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql.module;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import io.gitbub.devlibx.easy.helper.healthcheck.IHealthCheckProvider;
import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.easy.database.IDatabaseService;
import io.github.devlibx.easy.database.mysql.DataSourceFactory;
import io.github.devlibx.easy.database.mysql.DataSourceProxy;
import io.github.devlibx.easy.database.mysql.DatabaseService;
import io.github.devlibx.easy.database.mysql.IMysqlHelper;
import io.github.devlibx.easy.database.mysql.MySqlHelper;
import io.github.devlibx.easy.database.mysql.healthcheck.MySqlHealthCheckProvider;
import io.github.devlibx.easy.database.mysql.lock.MySqlLockBuilder;
import io.github.devlibx.easy.database.mysql.transaction.ITransactionManagerResolver;
import io.github.devlibx.easy.database.mysql.transaction.TransactionInterceptor;
import io.github.devlibx.easy.lock.ILockBuilder;
import io.github.devlibx.easy.lock.module.LockModule;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.guava.GuavaPlugin;
import org.jdbi.v3.jodatime2.JodaTimePlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.springframework.transaction.annotation.Transactional;

public class DatabaseMySQLModule
extends LockModule {
    private final boolean enableTransactionInterceptor;
    private final int defaultTimeout;

    public DatabaseMySQLModule() {
        this.enableTransactionInterceptor = true;
        this.defaultTimeout = 10;
    }

    public DatabaseMySQLModule(boolean enableTransactionInterceptor, int defaultTimeout) {
        this.enableTransactionInterceptor = enableTransactionInterceptor;
        this.defaultTimeout = defaultTimeout;
    }

    protected void configure() {
        super.configure();
        this.bind(DataSource.class).to(DataSourceProxy.class).in(Scopes.SINGLETON);
        this.bind(DataSourceFactory.class).in(Scopes.SINGLETON);
        this.bind(IMysqlHelper.class).to(MySqlHelper.class).in(Scopes.SINGLETON);
        this.bind(IDatabaseService.class).to(DatabaseService.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(Boolean.class, (Annotation)Names.named((String)"enable-transaction-aware-datasource"))).setDefault().toInstance((Object)Boolean.TRUE);
        if (this.enableTransactionInterceptor) {
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{this.transactionInterceptor()});
        }
        MapBinder healthCheckProviderMultiBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, IHealthCheckProvider.class);
        healthCheckProviderMultiBinder.permitDuplicates();
        healthCheckProviderMultiBinder.addBinding((Object)this.healthCheckRegistrationName()).to(MySqlHealthCheckProvider.class);
        MapBinder lockBuilderMapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, ILockBuilder.class);
        lockBuilderMapBinder.permitDuplicates();
        lockBuilderMapBinder.addBinding((Object)"MYSQL").to(MySqlLockBuilder.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(String.class, (Annotation)Names.named((String)"lock_table_name"))).setDefault().toInstance((Object)"locks");
        OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(DataSource.class, (Annotation)Names.named((String)"lock_table_data_source"))).setDefault().to(DataSourceProxy.class);
    }

    protected String healthCheckRegistrationName() {
        return "MySQL";
    }

    @Provides
    @Singleton
    private ITransactionManagerResolver internalTransactionManagerResolver() {
        return this.transactionManagerResolver();
    }

    protected ITransactionManagerResolver transactionManagerResolver() {
        return new ITransactionManagerResolver.DefaultTransactionManagerResolver();
    }

    protected TransactionInterceptor transactionInterceptor() {
        return new TransactionInterceptor(this.defaultTimeout, (Provider<ITransactionManagerResolver>)this.getProvider(ITransactionManagerResolver.class));
    }

    @Provides
    @Inject
    public Jdbi jdbi(DataSource dataSource) {
        Jdbi jdbi = Jdbi.create((DataSource)dataSource);
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        jdbi.installPlugin((JdbiPlugin)new JodaTimePlugin());
        jdbi.installPlugin((JdbiPlugin)new GuavaPlugin());
        jdbi.registerArgument((ArgumentFactory)new StringObjectMapArgumentFactory());
        return jdbi;
    }

    public static class StringObjectMapArgumentFactory
    extends AbstractArgumentFactory<StringObjectMap> {
        public StringObjectMapArgumentFactory() {
            super(12);
        }

        protected Argument build(StringObjectMap value, ConfigRegistry config) {
            return (position, statement, ctx) -> statement.setString(position, JsonUtils.asJson((Object)value));
        }
    }
}

