/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql.lock;

import com.zaxxer.hikari.HikariDataSource;
import io.gitbub.devlibx.easy.helper.Safe;
import io.github.devlibx.easy.lock.IDistributedLock;
import io.github.devlibx.easy.lock.IDistributedLockService;
import io.github.devlibx.easy.lock.config.LockConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlDistributedLock
implements IDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(MySqlDistributedLock.class);
    private static final ThreadLocal<InternalLock> lockInCurrentThread = new ThreadLocal();
    private final DataSource dataSource;
    private final String lockTableName;
    private LockConfig lockConfig;

    @Inject
    public MySqlDistributedLock(@Named(value="lock_table_data_source") DataSource dataSource, @Named(value="lock_table_name") String lockTableName) {
        this.dataSource = dataSource;
        this.lockTableName = lockTableName;
    }

    public void setup(LockConfig lockConfig) {
        this.lockConfig = lockConfig;
    }

    public void tearDown() {
        if (this.dataSource instanceof HikariDataSource) {
            Safe.safe(() -> ((HikariDataSource)((HikariDataSource)this.dataSource)).close());
        }
    }

    public Lock achieveLock(IDistributedLock.LockRequest request) {
        if (lockInCurrentThread.get() != null && Objects.equals(MySqlDistributedLock.lockInCurrentThread.get().request, request)) {
            return new IDistributedLockService.ExistingLockWithNoOp((Lock)lockInCurrentThread.get());
        }
        InternalLock internalLock = new InternalLock(this.dataSource, request, this.lockTableName, this.lockConfig);
        internalLock.lock();
        lockInCurrentThread.set(internalLock);
        return internalLock;
    }

    public void releaseLock(Lock lock, IDistributedLock.LockRequest lockRequest) {
        try {
            lock.unlock();
        }
        finally {
            lockInCurrentThread.set(null);
        }
    }

    private static class InternalLock
    implements Lock {
        private final DataSource dataSource;
        private final IDistributedLock.LockRequest request;
        private final String lockTableName;
        private Connection connection;
        private Connection insertConnection;
        private PreparedStatement insertStatement;
        private PreparedStatement lockStatement;
        private final LockConfig lockConfig;

        private InternalLock(DataSource dataSource, IDistributedLock.LockRequest request, String lockTableName, LockConfig lockConfig) {
            this.dataSource = dataSource;
            this.request = request;
            this.lockTableName = lockTableName;
            this.lockConfig = lockConfig;
        }

        @Override
        public void lock() {
            try {
                String lockIdToUse = this.request.getUniqueLockIdForLocking();
                log.debug("Try to insert lock: id={}", (Object)lockIdToUse);
                try (Connection connection = this.dataSource.getConnection();
                     PreparedStatement statement = connection.prepareStatement(String.format("INSERT IGNORE INTO %s(lock_id) VALUES(?)", this.lockTableName));){
                    statement.setQueryTimeout(this.lockConfig.getTimeoutInSec());
                    statement.setString(1, lockIdToUse);
                    statement.execute();
                    log.debug("Inserted lock: id={}", (Object)lockIdToUse);
                }
                catch (Exception e) {
                    log.error("Failed to insert lock for the first time", (Throwable)e);
                }
                log.debug("Try to lock with select for update: id={}", (Object)lockIdToUse);
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                this.lockStatement = this.connection.prepareStatement(String.format("SELECT * FROM %s WHERE lock_id=? FOR UPDATE", this.lockTableName));
                this.lockStatement.setQueryTimeout(this.lockConfig.getTimeoutInSec());
                this.lockStatement.setString(1, lockIdToUse);
                this.lockStatement.executeQuery();
                log.debug("Lock taken with select for update: id={}", (Object)lockIdToUse);
            }
            catch (Throwable e) {
                Safe.safe(() -> {
                    this.lockStatement.close();
                    this.lockStatement = null;
                });
                Safe.safe(() -> {
                    this.connection.setAutoCommit(true);
                    this.connection.rollback();
                    this.connection.close();
                    this.connection = null;
                });
                throw new RuntimeException(String.format("lock cannot be taken: name=%s, id=%s", this.request.getName(), this.request.getLockId()), e);
            }
        }

        @Override
        public void unlock() {
            log.debug("Try to unlock lock: id={}", (Object)this.request.getUniqueLockIdForLocking());
            try {
                Safe.safe(() -> {
                    this.lockStatement.close();
                    this.lockStatement = null;
                });
                this.connection.commit();
                this.connection.setAutoCommit(true);
                this.connection.close();
                this.connection = null;
                log.debug("Unlock done: id={}", (Object)this.request.getUniqueLockIdForLocking());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("lock cannot be released: name=%s, id=%s", this.request.getName(), this.request.getLockId()), e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean tryLock() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public Condition newCondition() {
            throw new RuntimeException("Not implemented");
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public IDistributedLock.LockRequest getRequest() {
            return this.request;
        }

        public String getLockTableName() {
            return this.lockTableName;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Connection getInsertConnection() {
            return this.insertConnection;
        }

        public PreparedStatement getInsertStatement() {
            return this.insertStatement;
        }

        public PreparedStatement getLockStatement() {
            return this.lockStatement;
        }

        public LockConfig getLockConfig() {
            return this.lockConfig;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        public void setInsertConnection(Connection insertConnection) {
            this.insertConnection = insertConnection;
        }

        public void setInsertStatement(PreparedStatement insertStatement) {
            this.insertStatement = insertStatement;
        }

        public void setLockStatement(PreparedStatement lockStatement) {
            this.lockStatement = lockStatement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InternalLock)) {
                return false;
            }
            InternalLock other = (InternalLock)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DataSource this$dataSource = this.getDataSource();
            DataSource other$dataSource = other.getDataSource();
            if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
                return false;
            }
            IDistributedLock.LockRequest this$request = this.getRequest();
            IDistributedLock.LockRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            String this$lockTableName = this.getLockTableName();
            String other$lockTableName = other.getLockTableName();
            if (this$lockTableName == null ? other$lockTableName != null : !this$lockTableName.equals(other$lockTableName)) {
                return false;
            }
            Connection this$connection = this.getConnection();
            Connection other$connection = other.getConnection();
            if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
                return false;
            }
            Connection this$insertConnection = this.getInsertConnection();
            Connection other$insertConnection = other.getInsertConnection();
            if (this$insertConnection == null ? other$insertConnection != null : !this$insertConnection.equals(other$insertConnection)) {
                return false;
            }
            PreparedStatement this$insertStatement = this.getInsertStatement();
            PreparedStatement other$insertStatement = other.getInsertStatement();
            if (this$insertStatement == null ? other$insertStatement != null : !this$insertStatement.equals(other$insertStatement)) {
                return false;
            }
            PreparedStatement this$lockStatement = this.getLockStatement();
            PreparedStatement other$lockStatement = other.getLockStatement();
            if (this$lockStatement == null ? other$lockStatement != null : !this$lockStatement.equals(other$lockStatement)) {
                return false;
            }
            LockConfig this$lockConfig = this.getLockConfig();
            LockConfig other$lockConfig = other.getLockConfig();
            return !(this$lockConfig == null ? other$lockConfig != null : !this$lockConfig.equals(other$lockConfig));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InternalLock;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DataSource $dataSource = this.getDataSource();
            result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
            IDistributedLock.LockRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            String $lockTableName = this.getLockTableName();
            result = result * 59 + ($lockTableName == null ? 43 : $lockTableName.hashCode());
            Connection $connection = this.getConnection();
            result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
            Connection $insertConnection = this.getInsertConnection();
            result = result * 59 + ($insertConnection == null ? 43 : $insertConnection.hashCode());
            PreparedStatement $insertStatement = this.getInsertStatement();
            result = result * 59 + ($insertStatement == null ? 43 : $insertStatement.hashCode());
            PreparedStatement $lockStatement = this.getLockStatement();
            result = result * 59 + ($lockStatement == null ? 43 : $lockStatement.hashCode());
            LockConfig $lockConfig = this.getLockConfig();
            result = result * 59 + ($lockConfig == null ? 43 : $lockConfig.hashCode());
            return result;
        }

        public String toString() {
            return "MySqlDistributedLock.InternalLock(dataSource=" + this.getDataSource() + ", request=" + this.getRequest() + ", lockTableName=" + this.getLockTableName() + ", connection=" + this.getConnection() + ", insertConnection=" + this.getInsertConnection() + ", insertStatement=" + this.getInsertStatement() + ", lockStatement=" + this.getLockStatement() + ", lockConfig=" + this.getLockConfig() + ")";
        }
    }
}

