/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql.transaction;

import com.google.inject.Provider;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.github.devlibx.easy.database.mysql.DataSourceFactory;
import io.github.devlibx.easy.database.mysql.transaction.ITransactionManagerResolver;
import io.github.devlibx.easy.database.mysql.transaction.TransactionContext;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class TransactionInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TransactionInterceptor.class);
    private final Map<String, DataSourceTransactionManager> transactionManagerMap;
    private final int defaultTimeout;
    private final Provider<ITransactionManagerResolver> transactionManagerResolver;

    public TransactionInterceptor(int defaultTimeout, Provider<ITransactionManagerResolver> transactionManagerResolver) {
        this.transactionManagerResolver = transactionManagerResolver;
        this.transactionManagerMap = new ConcurrentHashMap<String, DataSourceTransactionManager>();
        this.defaultTimeout = defaultTimeout;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Transactional transactional = invocation.getMethod().getAnnotation(Transactional.class);
        if (transactional == null) {
            log.trace("Execute method without transaction - method is not marked with Transactional");
            return invocation.proceed();
        }
        TransactionContext.getInstance().clear();
        this.resolveTransactionManagerByName(transactional);
        TransactionContext.Context context = TransactionContext.getInstance().getContext().cloneContext();
        DataSourceTransactionManager transactionManager = this.ensureDataSourceTransactionManager();
        if (transactionManager == null) {
            log.trace("Execute method without transaction - method is marked with Transactional, but we do not have transaction manager with name={}", (Object)context.getDatasourceName());
            return invocation.proceed();
        }
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(transactional.propagation().value());
        definition.setName(transactional.value());
        definition.setTimeout(transactional.timeout() > 0 ? transactional.timeout() : 10);
        DefaultTransactionStatus transactionStatus = (DefaultTransactionStatus)transactionManager.getTransaction((TransactionDefinition)definition);
        this.resolveName(transactional, definition);
        try {
            Object result = invocation.proceed();
            log.trace("Execute with transaction (commit) - result={}", result);
            transactionManager.commit((TransactionStatus)transactionStatus);
            Object object = result;
            return object;
        }
        catch (Exception e) {
            log.trace("Execute with transaction failed (rollback) - exception={}", (Object)e.getMessage(), (Object)e);
            transactionManager.rollback((TransactionStatus)transactionStatus);
            throw e;
        }
        finally {
            TransactionContext.getInstance().clear();
        }
    }

    private void resolveTransactionManagerByName(Transactional transactional) {
        String transactionManagerToUse = ((ITransactionManagerResolver)this.transactionManagerResolver.get()).resolveTransactionManager(transactional);
        TransactionContext.Context context = TransactionContext.getInstance().getContext();
        context.setDatasourceName(transactionManagerToUse);
    }

    private void resolveName(Transactional transactional, DefaultTransactionDefinition definition) {
        if (transactional.label().length == 0) {
            return;
        }
        for (String label : transactional.label()) {
            StringTokenizer st = new StringTokenizer(label, "=");
            String token = st.nextToken();
            if (!Objects.equals("name", token)) continue;
            definition.setName(st.nextToken());
        }
    }

    private synchronized DataSourceTransactionManager ensureDataSourceTransactionManager() {
        TransactionContext.Context context = TransactionContext.getInstance().getContext();
        String dataSourceName = context.getDatasourceName();
        if (this.transactionManagerMap.containsKey(dataSourceName)) {
            return this.transactionManagerMap.get(dataSourceName);
        }
        DataSourceFactory dataSourceFactory = (DataSourceFactory)ApplicationContext.getInstance(DataSourceFactory.class);
        DataSource dataSource = dataSourceFactory.getDataSource(dataSourceName);
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
            transactionManager.setDefaultTimeout(this.defaultTimeout);
            this.transactionManagerMap.put(dataSourceName, transactionManager);
            log.info("Created new dataSourceManager for dataSource={}", (Object)dataSourceName);
        }
        return this.transactionManagerMap.get(dataSourceName);
    }
}

