/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.LoggerFactory;

public class LoggingHelper {
    private static final AtomicBoolean initDone = new AtomicBoolean(false);

    public static void setupLogging() {
        try {
            LoggingHelper.setupLoggingLogbackClassic();
        }
        catch (Exception e) {
            try {
                LoggingHelper.setupLoggingApacheLog4j();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupLoggingApacheLog4j() {
        AtomicBoolean atomicBoolean = initDone;
        synchronized (atomicBoolean) {
            if (initDone.get()) {
                return;
            }
            initDone.set(true);
        }
    }

    private static void setupLoggingLogbackClassic() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.getLogger("ROOT").setLevel(Level.INFO);
    }

    public static Logger getLogger(Class<?> clazz) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        return loggerContext.getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        return loggerContext.getLogger(name);
    }
}

