/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.map.Maps;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import java.util.Map;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class LogEvent {
    private static String SERVICE_NAME_FOR_APPLICATION;
    @JsonProperty(value="__service__")
    private String service;
    @JsonProperty(value="__timestamp__")
    private long timestamp;
    @JsonProperty(value="__unique_id__")
    private String uniqueId;
    @JsonProperty(value="event_type")
    private String eventType;
    @JsonProperty(value="event_sub_type")
    private String eventSubType;
    @JsonProperty(value="dimensions")
    private Map<String, String> dimensions;
    @JsonProperty(value="entity")
    private Entity entity;
    @JsonProperty(value="data")
    private StringObjectMap data;

    public static Builder build(String eventType) {
        return Builder.withEventType(eventType);
    }

    public static Builder build(String eventType, String eventSubType) {
        return Builder.withEventTypeSubType(eventType, eventSubType);
    }

    public static void setGlobalServiceName(String serviceName) {
        SERVICE_NAME_FOR_APPLICATION = serviceName;
    }

    public String getService() {
        return this.service;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventSubType() {
        return this.eventSubType;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public StringObjectMap getData() {
        return this.data;
    }

    @JsonProperty(value="__service__")
    public void setService(String service) {
        this.service = service;
    }

    @JsonProperty(value="__timestamp__")
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="__unique_id__")
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @JsonProperty(value="event_type")
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @JsonProperty(value="event_sub_type")
    public void setEventSubType(String eventSubType) {
        this.eventSubType = eventSubType;
    }

    @JsonProperty(value="dimensions")
    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    @JsonProperty(value="entity")
    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @JsonProperty(value="data")
    public void setData(StringObjectMap data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEvent)) {
            return false;
        }
        LogEvent other = (LogEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$eventSubType = this.getEventSubType();
        String other$eventSubType = other.getEventSubType();
        if (this$eventSubType == null ? other$eventSubType != null : !this$eventSubType.equals(other$eventSubType)) {
            return false;
        }
        Map<String, String> this$dimensions = this.getDimensions();
        Map<String, String> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        Entity this$entity = this.getEntity();
        Entity other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity)) {
            return false;
        }
        StringObjectMap this$data = this.getData();
        StringObjectMap other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $eventSubType = this.getEventSubType();
        result = result * 59 + ($eventSubType == null ? 43 : $eventSubType.hashCode());
        Map<String, String> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        Entity $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
        StringObjectMap $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "LogEvent(service=" + this.getService() + ", timestamp=" + this.getTimestamp() + ", uniqueId=" + this.getUniqueId() + ", eventType=" + this.getEventType() + ", eventSubType=" + this.getEventSubType() + ", dimensions=" + this.getDimensions() + ", entity=" + this.getEntity() + ", data=" + this.getData() + ")";
    }

    public static class Builder {
        private final LogEvent logEvent = new LogEvent();

        public static Builder withEventType(String eventType) {
            if (Strings.isNullOrEmpty((String)SERVICE_NAME_FOR_APPLICATION)) {
                throw new RuntimeException("Please set global application name using LogEvent.setGlobalServiceName(XYZ) at boot-up");
            }
            Builder builder = new Builder();
            builder.logEvent.service = SERVICE_NAME_FOR_APPLICATION;
            builder.logEvent.eventType = eventType;
            return builder;
        }

        public static Builder withEventTypeSubType(String eventType, String eventSubType) {
            if (Strings.isNullOrEmpty((String)SERVICE_NAME_FOR_APPLICATION)) {
                throw new RuntimeException("Please set global application name using LogEvent.setGlobalServiceName(XYZ) at boot-up");
            }
            Builder builder = new Builder();
            builder.logEvent.service = SERVICE_NAME_FOR_APPLICATION;
            builder.logEvent.eventType = eventType;
            builder.logEvent.eventSubType = eventSubType;
            return builder;
        }

        public Builder entity(String entityType, String entityId) {
            this.logEvent.entity = new Entity();
            this.logEvent.entity.type = entityType;
            this.logEvent.entity.id = entityId;
            return this;
        }

        public Builder data(StringObjectMap data) {
            this.logEvent.data = data;
            return this;
        }

        public Builder dimensions(Map<String, String> dimensions) {
            if (this.logEvent.dimensions == null) {
                this.logEvent.dimensions = dimensions;
            } else {
                this.logEvent.dimensions.putAll(dimensions);
            }
            return this;
        }

        public Builder dimensions(String key, String value) {
            Map<String, String> m = Maps.of(key, value);
            if (this.logEvent.dimensions == null) {
                this.logEvent.dimensions = m;
            } else {
                this.logEvent.dimensions.putAll(m);
            }
            return this;
        }

        public Builder dimensions(String key1, String value1, String key2, String value2) {
            Map<String, String> m = Maps.of(key1, value1, key2, value2);
            if (this.logEvent.dimensions == null) {
                this.logEvent.dimensions = m;
            } else {
                this.logEvent.dimensions.putAll(m);
            }
            return this;
        }

        public Builder dimensions(String key1, String value1, String key2, String value2, String key3, String value3) {
            Map<String, String> m = Maps.of(key1, value1, key2, value2, key3, value3);
            if (this.logEvent.dimensions == null) {
                this.logEvent.dimensions = m;
            } else {
                this.logEvent.dimensions.putAll(m);
            }
            return this;
        }

        public Builder dimensions(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4) {
            Map<String, String> m = Maps.of(key1, value1, key2, value2, key3, value3, key4, value4);
            if (this.logEvent.dimensions == null) {
                this.logEvent.dimensions = m;
            } else {
                this.logEvent.dimensions.putAll(m);
            }
            return this;
        }

        public Builder dimensions(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4, String key5, String value5) {
            Map<String, String> m = Maps.of(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
            if (this.logEvent.dimensions == null) {
                this.logEvent.dimensions = m;
            } else {
                this.logEvent.dimensions.putAll(m);
            }
            return this;
        }

        public Builder dimensions(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4, String key5, String value5, String key6, String value6) {
            Map<String, String> m = Maps.of(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6);
            if (this.logEvent.dimensions == null) {
                this.logEvent.dimensions = m;
            } else {
                this.logEvent.dimensions.putAll(m);
            }
            return this;
        }

        public Builder data(String key, Object value) {
            StringObjectMap m = StringObjectMap.of(key, value);
            if (this.logEvent.data == null) {
                this.logEvent.data = m;
            } else {
                this.logEvent.data.putAll(m);
            }
            return this;
        }

        public Builder data(String key1, Object value1, String key2, Object value2) {
            StringObjectMap m = StringObjectMap.of(key1, value1, key2, value2);
            if (this.logEvent.data == null) {
                this.logEvent.data = m;
            } else {
                this.logEvent.data.putAll(m);
            }
            return this;
        }

        public Builder data(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
            StringObjectMap m = StringObjectMap.of(key1, value1, key2, value2, key3, value3);
            if (this.logEvent.data == null) {
                this.logEvent.data = m;
            } else {
                this.logEvent.data.putAll(m);
            }
            return this;
        }

        public Builder data(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
            StringObjectMap m = StringObjectMap.of(key1, value1, key2, value2, key3, value3, key4, value4);
            if (this.logEvent.data == null) {
                this.logEvent.data = m;
            } else {
                this.logEvent.data.putAll(m);
            }
            return this;
        }

        public Builder data(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
            StringObjectMap m = StringObjectMap.of(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
            if (this.logEvent.data == null) {
                this.logEvent.data = m;
            } else {
                this.logEvent.data.putAll(m);
            }
            return this;
        }

        public Builder data(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
            StringObjectMap m = StringObjectMap.of(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6);
            if (this.logEvent.data == null) {
                this.logEvent.data = m;
            } else {
                this.logEvent.data.putAll(m);
            }
            return this;
        }

        public LogEvent build() {
            this.logEvent.uniqueId = UUID.randomUUID().toString();
            this.logEvent.timestamp = System.currentTimeMillis();
            return this.logEvent;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Entity {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="id")
        private String id;

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entity)) {
                return false;
            }
            Entity other = (Entity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "LogEvent.Entity(type=" + this.getType() + ", id=" + this.getId() + ")";
        }

        public Entity(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public Entity() {
        }
    }
}

