/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.gitbub.devlibx.easy.helper.json.JsonUtil;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.gitbub.devlibx.easy.helper.string.StringHelper;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static final JsonUtil jsonUtil = new JsonUtil();
    private static final JsonUtil camelCaseJsonUtil;
    private static final StringHelper stringHelper;

    public static JsonUtil getCamelCase() {
        return camelCaseJsonUtil;
    }

    public static <T> T readObject(String str, Class<T> cls) {
        return jsonUtil.readObject(str, cls);
    }

    public static <T> T readObject(String str, JavaType cls) {
        return jsonUtil.readObject(str, cls);
    }

    public static Map<String, Object> convertAsMap(String str) {
        return jsonUtil.convertAsMap(str);
    }

    public static StringObjectMap convertAsStringObjectMap(String str) {
        return jsonUtil.convertAsStringObjectMap(str);
    }

    public static StringObjectMap convertAsStringObjectMap(byte[] bytes) {
        return jsonUtil.convertAsStringObjectMap(bytes);
    }

    public static String asJson(Object object) {
        return stringHelper.stringify(object);
    }

    public static <T> List<T> readList(String str, Class<T> cls) {
        return jsonUtil.readList(str, cls);
    }

    static {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        camelCaseJsonUtil = new JsonUtil(objectMapper);
        stringHelper = new StringHelper(jsonUtil);
    }
}

