/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.gitbub.devlibx.easy.helper.string.StringHelper;
import io.github.devlibx.easy.http.IApiConfigPreProcessor;
import io.github.devlibx.easy.http.RequestObject;
import io.github.devlibx.easy.http.helper.ConcurrencyApiConfigPreProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Api
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Api.class);
    public static final List<Integer> DEFAULT_ACCEPTABLE_CODES = Collections.unmodifiableList(Arrays.asList(200, 201));
    private String name;
    private String fallbackApiName;
    private boolean async;
    private boolean noWarmUp;
    private String server;
    private String method = "GET";
    private String type = "HTTP";
    private List<Integer> acceptableCodes = DEFAULT_ACCEPTABLE_CODES;
    private String path;
    private int concurrency = 2;
    private int queueSize = 10;
    private int timeout = 1000;
    private int waitBeforeClosingCircuitAfterError = 10000;
    private int rps = 0;
    private List<String> configPreProcessors = Collections.singletonList(ConcurrencyApiConfigPreProcessor.class.getCanonicalName());
    private StringObjectMap headers;
    private float timeoutDeltaFactor = 0.0f;

    public String getUrlForRequestObject(RequestObject requestObject, StringHelper stringHelper) {
        return this.getUrlWithPathParamAndQueryParam(requestObject.getPathParam(), requestObject.getQueryParam(), stringHelper);
    }

    public String getUrlWithPathParamAndQueryParam(Map<String, Object> pathParam, MultivaluedMap<String, Object> queryParam, StringHelper stringHelper) {
        String uri = this.getPath();
        if (!Strings.isNullOrEmpty((String)uri) && pathParam != null) {
            uri = StrSubstitutor.replace((Object)this.getPath(), pathParam);
        }
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = "/";
        }
        uri = uri.startsWith("/") ? uri : "/" + uri;
        StringBuilder sb = new StringBuilder();
        if (queryParam != null) {
            queryParam.forEach((key, values) -> values.forEach(value -> {
                if (!sb.toString().isEmpty()) {
                    sb.append("&");
                }
                sb.append((String)key).append("=").append(value);
            }));
        }
        String qp = sb.toString();
        return uri + (Strings.isNullOrEmpty((String)qp) ? "" : "?" + qp);
    }

    public List<IApiConfigPreProcessor> getConfigPreProcessorList() {
        ArrayList<IApiConfigPreProcessor> items = new ArrayList<IApiConfigPreProcessor>();
        if (this.configPreProcessors != null) {
            this.configPreProcessors.forEach(name -> {
                try {
                    Class<?> cls = Class.forName(name);
                    items.add((IApiConfigPreProcessor)cls.newInstance());
                    log.debug("Create instance of - {}", name);
                }
                catch (Exception e) {
                    log.error("Failed to create IApiConfigPreProcessor from: {}", name, (Object)e);
                }
            });
        }
        return items;
    }

    public String getName() {
        return this.name;
    }

    public String getFallbackApiName() {
        return this.fallbackApiName;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isNoWarmUp() {
        return this.noWarmUp;
    }

    public String getServer() {
        return this.server;
    }

    public String getMethod() {
        return this.method;
    }

    public String getType() {
        return this.type;
    }

    public List<Integer> getAcceptableCodes() {
        return this.acceptableCodes;
    }

    public String getPath() {
        return this.path;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getWaitBeforeClosingCircuitAfterError() {
        return this.waitBeforeClosingCircuitAfterError;
    }

    public int getRps() {
        return this.rps;
    }

    public List<String> getConfigPreProcessors() {
        return this.configPreProcessors;
    }

    public StringObjectMap getHeaders() {
        return this.headers;
    }

    public float getTimeoutDeltaFactor() {
        return this.timeoutDeltaFactor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFallbackApiName(String fallbackApiName) {
        this.fallbackApiName = fallbackApiName;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setNoWarmUp(boolean noWarmUp) {
        this.noWarmUp = noWarmUp;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAcceptableCodes(List<Integer> acceptableCodes) {
        this.acceptableCodes = acceptableCodes;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setWaitBeforeClosingCircuitAfterError(int waitBeforeClosingCircuitAfterError) {
        this.waitBeforeClosingCircuitAfterError = waitBeforeClosingCircuitAfterError;
    }

    public void setRps(int rps) {
        this.rps = rps;
    }

    public void setConfigPreProcessors(List<String> configPreProcessors) {
        this.configPreProcessors = configPreProcessors;
    }

    public void setHeaders(StringObjectMap headers) {
        this.headers = headers;
    }

    public void setTimeoutDeltaFactor(float timeoutDeltaFactor) {
        this.timeoutDeltaFactor = timeoutDeltaFactor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Api)) {
            return false;
        }
        Api other = (Api)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        if (this.isNoWarmUp() != other.isNoWarmUp()) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getWaitBeforeClosingCircuitAfterError() != other.getWaitBeforeClosingCircuitAfterError()) {
            return false;
        }
        if (this.getRps() != other.getRps()) {
            return false;
        }
        if (Float.compare(this.getTimeoutDeltaFactor(), other.getTimeoutDeltaFactor()) != 0) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fallbackApiName = this.getFallbackApiName();
        String other$fallbackApiName = other.getFallbackApiName();
        if (this$fallbackApiName == null ? other$fallbackApiName != null : !this$fallbackApiName.equals(other$fallbackApiName)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<Integer> this$acceptableCodes = this.getAcceptableCodes();
        List<Integer> other$acceptableCodes = other.getAcceptableCodes();
        if (this$acceptableCodes == null ? other$acceptableCodes != null : !((Object)this$acceptableCodes).equals(other$acceptableCodes)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<String> this$configPreProcessors = this.getConfigPreProcessors();
        List<String> other$configPreProcessors = other.getConfigPreProcessors();
        if (this$configPreProcessors == null ? other$configPreProcessors != null : !((Object)this$configPreProcessors).equals(other$configPreProcessors)) {
            return false;
        }
        StringObjectMap this$headers = this.getHeaders();
        StringObjectMap other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Api;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsync() ? 79 : 97);
        result = result * 59 + (this.isNoWarmUp() ? 79 : 97);
        result = result * 59 + this.getConcurrency();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getWaitBeforeClosingCircuitAfterError();
        result = result * 59 + this.getRps();
        result = result * 59 + Float.floatToIntBits(this.getTimeoutDeltaFactor());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fallbackApiName = this.getFallbackApiName();
        result = result * 59 + ($fallbackApiName == null ? 43 : $fallbackApiName.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<Integer> $acceptableCodes = this.getAcceptableCodes();
        result = result * 59 + ($acceptableCodes == null ? 43 : ((Object)$acceptableCodes).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<String> $configPreProcessors = this.getConfigPreProcessors();
        result = result * 59 + ($configPreProcessors == null ? 43 : ((Object)$configPreProcessors).hashCode());
        StringObjectMap $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    public String toString() {
        return "Api(name=" + this.getName() + ", fallbackApiName=" + this.getFallbackApiName() + ", async=" + this.isAsync() + ", noWarmUp=" + this.isNoWarmUp() + ", server=" + this.getServer() + ", method=" + this.getMethod() + ", type=" + this.getType() + ", acceptableCodes=" + this.getAcceptableCodes() + ", path=" + this.getPath() + ", concurrency=" + this.getConcurrency() + ", queueSize=" + this.getQueueSize() + ", timeout=" + this.getTimeout() + ", waitBeforeClosingCircuitAfterError=" + this.getWaitBeforeClosingCircuitAfterError() + ", rps=" + this.getRps() + ", configPreProcessors=" + this.getConfigPreProcessors() + ", headers=" + this.getHeaders() + ", timeoutDeltaFactor=" + this.getTimeoutDeltaFactor() + ")";
    }

    public Api() {
    }

    public Api(String name, String fallbackApiName, boolean async, boolean noWarmUp, String server, String method, String type, List<Integer> acceptableCodes, String path, int concurrency, int queueSize, int timeout, int waitBeforeClosingCircuitAfterError, int rps, List<String> configPreProcessors, StringObjectMap headers, float timeoutDeltaFactor) {
        this.name = name;
        this.fallbackApiName = fallbackApiName;
        this.async = async;
        this.noWarmUp = noWarmUp;
        this.server = server;
        this.method = method;
        this.type = type;
        this.acceptableCodes = acceptableCodes;
        this.path = path;
        this.concurrency = concurrency;
        this.queueSize = queueSize;
        this.timeout = timeout;
        this.waitBeforeClosingCircuitAfterError = waitBeforeClosingCircuitAfterError;
        this.rps = rps;
        this.configPreProcessors = configPreProcessors;
        this.headers = headers;
        this.timeoutDeltaFactor = timeoutDeltaFactor;
    }
}

