/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Server
implements Serializable {
    private String name;
    private String host;
    private boolean isHttps = false;
    private int port = 80;
    private int pollingConnectionTtlInMs = 60000;
    private int idleConnectionTimeoutInSec = 60;
    private int connectionRequestTimeout = 100;
    private int connectTimeout = 100;

    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        if (this.isHttps) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(this.host);
        sb.append(":");
        sb.append(this.port);
        return sb.toString();
    }

    public static ServerBuilder builder() {
        return new ServerBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isHttps() {
        return this.isHttps;
    }

    public int getPort() {
        return this.port;
    }

    public int getPollingConnectionTtlInMs() {
        return this.pollingConnectionTtlInMs;
    }

    public int getIdleConnectionTimeoutInSec() {
        return this.idleConnectionTimeoutInSec;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setHttps(boolean isHttps) {
        this.isHttps = isHttps;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPollingConnectionTtlInMs(int pollingConnectionTtlInMs) {
        this.pollingConnectionTtlInMs = pollingConnectionTtlInMs;
    }

    public void setIdleConnectionTimeoutInSec(int idleConnectionTimeoutInSec) {
        this.idleConnectionTimeoutInSec = idleConnectionTimeoutInSec;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHttps() != other.isHttps()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getPollingConnectionTtlInMs() != other.getPollingConnectionTtlInMs()) {
            return false;
        }
        if (this.getIdleConnectionTimeoutInSec() != other.getIdleConnectionTimeoutInSec()) {
            return false;
        }
        if (this.getConnectionRequestTimeout() != other.getConnectionRequestTimeout()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHttps() ? 79 : 97);
        result = result * 59 + this.getPort();
        result = result * 59 + this.getPollingConnectionTtlInMs();
        result = result * 59 + this.getIdleConnectionTimeoutInSec();
        result = result * 59 + this.getConnectionRequestTimeout();
        result = result * 59 + this.getConnectTimeout();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "Server(name=" + this.getName() + ", host=" + this.getHost() + ", isHttps=" + this.isHttps() + ", port=" + this.getPort() + ", pollingConnectionTtlInMs=" + this.getPollingConnectionTtlInMs() + ", idleConnectionTimeoutInSec=" + this.getIdleConnectionTimeoutInSec() + ", connectionRequestTimeout=" + this.getConnectionRequestTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ")";
    }

    public Server() {
    }

    public Server(String name, String host, boolean isHttps, int port, int pollingConnectionTtlInMs, int idleConnectionTimeoutInSec, int connectionRequestTimeout, int connectTimeout) {
        this.name = name;
        this.host = host;
        this.isHttps = isHttps;
        this.port = port;
        this.pollingConnectionTtlInMs = pollingConnectionTtlInMs;
        this.idleConnectionTimeoutInSec = idleConnectionTimeoutInSec;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.connectTimeout = connectTimeout;
    }

    public static class ServerBuilder {
        private String name;
        private String host;
        private boolean isHttps;
        private int port;
        private int pollingConnectionTtlInMs;
        private int idleConnectionTimeoutInSec;
        private int connectionRequestTimeout;
        private int connectTimeout;

        ServerBuilder() {
        }

        public ServerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ServerBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ServerBuilder isHttps(boolean isHttps) {
            this.isHttps = isHttps;
            return this;
        }

        public ServerBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ServerBuilder pollingConnectionTtlInMs(int pollingConnectionTtlInMs) {
            this.pollingConnectionTtlInMs = pollingConnectionTtlInMs;
            return this;
        }

        public ServerBuilder idleConnectionTimeoutInSec(int idleConnectionTimeoutInSec) {
            this.idleConnectionTimeoutInSec = idleConnectionTimeoutInSec;
            return this;
        }

        public ServerBuilder connectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public ServerBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Server build() {
            return new Server(this.name, this.host, this.isHttps, this.port, this.pollingConnectionTtlInMs, this.idleConnectionTimeoutInSec, this.connectionRequestTimeout, this.connectTimeout);
        }

        public String toString() {
            return "Server.ServerBuilder(name=" + this.name + ", host=" + this.host + ", isHttps=" + this.isHttps + ", port=" + this.port + ", pollingConnectionTtlInMs=" + this.pollingConnectionTtlInMs + ", idleConnectionTimeoutInSec=" + this.idleConnectionTimeoutInSec + ", connectionRequestTimeout=" + this.connectionRequestTimeout + ", connectTimeout=" + this.connectTimeout + ")";
        }
    }
}

