/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.helper;

import io.github.devlibx.easy.http.config.Api;
import io.github.devlibx.easy.http.config.Server;
import io.github.devlibx.easy.http.helper.IClientBuilder;
import io.netty.channel.ChannelHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public class AsyncHttpClientBuilder
implements IClientBuilder {
    private final Map<String, WebClient> httpClientMap = new HashMap<String, WebClient>();

    @Override
    public boolean accept(Server server, Api api) {
        if (!api.isAsync()) {
            return false;
        }
        return "HTTP".equals(api.getType()) || "HTTPS".equals(api.getType());
    }

    @Override
    public <T> T buildClient(Server server, Api api, Class<T> cls) {
        if (!cls.isAssignableFrom(WebClient.class)) {
            throw new RuntimeException("cls type must be CloseableHttpClient");
        }
        String key = server.getName() + "-" + api.getName();
        if (this.httpClientMap.containsKey(key)) {
            return (T)this.httpClientMap.get(key);
        }
        HttpClient httpClient = HttpClient.create((ConnectionProvider)ConnectionProvider.create((String)(server.getName() + "-" + api.getName()), (int)api.getConcurrency())).tcpConfiguration(tcpClient -> tcpClient.doOnConnected(connection -> connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)api.getTimeout(), TimeUnit.MILLISECONDS))));
        WebClient webClient = WebClient.builder().baseUrl(server.getUrl()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
        this.httpClientMap.put(key, webClient);
        return (T)webClient;
    }

    @Override
    public void shutdown() {
    }
}

