/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.sync;

import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.Safe;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.gitbub.devlibx.easy.helper.string.StringHelper;
import io.github.devlibx.easy.http.IRequestProcessor;
import io.github.devlibx.easy.http.RequestObject;
import io.github.devlibx.easy.http.ResponseObject;
import io.github.devlibx.easy.http.config.Api;
import io.github.devlibx.easy.http.config.Server;
import io.github.devlibx.easy.http.registry.ApiRegistry;
import io.github.devlibx.easy.http.registry.ServerRegistry;
import io.github.devlibx.easy.http.sync.IHttpResponseProcessor;
import io.reactivex.rxjava3.core.Observable;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRequestProcessor
implements IRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(SyncRequestProcessor.class);
    private final ServerRegistry serverRegistry;
    private final ApiRegistry apiRegistry;
    private final StringHelper stringHelper;
    private final IHttpResponseProcessor httpResponseProcessor;
    private final IMetrics metrics;

    @Inject
    public SyncRequestProcessor(ServerRegistry serverRegistry, ApiRegistry apiRegistry, IHttpResponseProcessor httpResponseProcessor, IMetrics metrics) {
        this.serverRegistry = serverRegistry;
        this.apiRegistry = apiRegistry;
        this.httpResponseProcessor = httpResponseProcessor;
        this.metrics = metrics;
        this.stringHelper = ApplicationContext.getOptionalInstance(StringHelper.class).orElse(new StringHelper());
    }

    @Override
    public void shutdown() {
        Safe.safe(this.apiRegistry::shutdown);
        Safe.safe(this.serverRegistry::shutdown);
    }

    @Override
    public Observable<ResponseObject> process(RequestObject requestObject) {
        Api api = this.apiRegistry.getOptional(requestObject.getApi()).orElseThrow(() -> new RuntimeException("Could not find api=" + requestObject.getApi()));
        Server server = this.serverRegistry.getOptional(api.getServer()).orElseThrow(() -> new RuntimeException("Could not find server=" + api.getServer()));
        if (Strings.isNullOrEmpty((String)requestObject.getMethod())) {
            requestObject.setMethod(api.getMethod());
        }
        return Observable.create(observableEmitter -> {
            try {
                ResponseObject responseObject = this.internalProcess(server, api, requestObject);
                if (responseObject != null) {
                    observableEmitter.onNext((Object)responseObject);
                }
                observableEmitter.onComplete();
            }
            catch (Exception e) {
                if (!Strings.isNullOrEmpty((String)api.getFallbackApiName())) {
                    log.info("Going to fallback: server={}, api={}, fallbackApi={}", new Object[]{server.getName(), api.getName(), api.getFallbackApiName()});
                    Api fallbackApi = this.apiRegistry.getOptional(api.getFallbackApiName()).orElseThrow(() -> new RuntimeException("Could not find fallback api=" + api.getFallbackApiName()));
                    Server fallbackServer = this.serverRegistry.getOptional(fallbackApi.getServer()).orElseThrow(() -> new RuntimeException("Could not find fallback server=" + fallbackApi.getServer()));
                    if (Strings.isNullOrEmpty((String)requestObject.getMethod())) {
                        requestObject.setMethod(api.getMethod());
                    }
                    try {
                        ResponseObject responseObject = this.internalProcess(fallbackServer, fallbackApi, requestObject);
                        if (responseObject != null) {
                            observableEmitter.onNext((Object)responseObject);
                        }
                        observableEmitter.onComplete();
                    }
                    catch (Exception e1) {
                        observableEmitter.onError((Throwable)e1);
                    }
                }
                observableEmitter.onError((Throwable)e);
            }
        });
    }

    private ResponseObject internalProcess(Server server, Api api, RequestObject requestObject) {
        switch (requestObject.getMethod()) {
            case "GET": {
                return this.internalProcess(server, api, requestObject, uri -> {
                    HttpGet get = new HttpGet(uri);
                    return get;
                }, HttpGet.class);
            }
            case "POST": {
                return this.internalProcess(server, api, requestObject, uri -> {
                    HttpPost post = new HttpPost(uri);
                    if (requestObject.getBody() != null) {
                        post.setEntity((HttpEntity)new ByteArrayEntity(requestObject.getBody()));
                    }
                    return post;
                }, HttpPost.class);
            }
            case "PUT": {
                return this.internalProcess(server, api, requestObject, uri -> {
                    HttpPut put = new HttpPut(uri);
                    if (requestObject.getBody() != null) {
                        put.setEntity((HttpEntity)new ByteArrayEntity(requestObject.getBody()));
                    }
                    return put;
                }, HttpPut.class);
            }
            case "DELETE": {
                return this.internalProcess(server, api, requestObject, uri -> {
                    HttpDelete delete = new HttpDelete(uri);
                    return delete;
                }, HttpDelete.class);
            }
        }
        return null;
    }

    private <REQ_TYPE extends HttpRequestBase> ResponseObject internalProcess(Server server, Api api, RequestObject requestObject, Function<URI, REQ_TYPE> func, Class<REQ_TYPE> cls) {
        ResponseObject responseObject;
        URI uri;
        try {
            uri = this.generateURI(server, api, requestObject);
            log.debug("URL to use = {}", (Object)uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to generate URI");
        }
        HttpRequestBase requestBase = (HttpRequestBase)func.apply(uri);
        requestBase.setConfig(this.buildRequestConfig(server, api, requestObject));
        if (server.getHeaders() != null) {
            server.getHeaders().forEach((key, value) -> requestBase.addHeader(key, this.stringHelper.stringify(value)));
        }
        requestObject.preProcessHeaders(api.getHeaders());
        requestObject.getHeaders().forEach((key, value) -> requestBase.addHeader(key, this.stringHelper.stringify(value)));
        CloseableHttpClient client = this.apiRegistry.getClient(server, api, CloseableHttpClient.class);
        long startTime = System.currentTimeMillis();
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)requestBase);){
            responseObject = this.httpResponseProcessor.process(this.serverRegistry.get(api.getServer()), api, response);
            this.metrics.observe(server.getName() + "_" + api.getName() + "_http_client_time", (double)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            this.metrics.observe(server.getName() + "_" + api.getName() + "_http_client_error_time", (double)(System.currentTimeMillis() - startTime));
            log.error("Unknown issue: request={}", (Object)requestObject, (Object)e);
            responseObject = this.httpResponseProcessor.processException(server, api, e);
        }
        if (requestObject.getResponseBuilder() == null) {
            log.debug("Request={} Response={}", (Object)requestObject, responseObject.convertAsMap());
        } else {
            try {
                log.debug("Request={} Response={}", (Object)requestObject, requestObject.getResponseBuilder().apply(responseObject.getBody()));
            }
            catch (Exception e) {
                log.debug("Request={} Response={}", new Object[]{requestObject, "Failed to build response from body using responseBuilder function", e});
            }
        }
        this.httpResponseProcessor.processResponseForException(responseObject);
        return responseObject;
    }

    private RequestConfig buildRequestConfig(Server server, Api api, RequestObject request) {
        int socketTimeoutToBeUsed = api.getTimeout();
        if (api.getTimeoutDeltaFactor() > 0.0f) {
            socketTimeoutToBeUsed = (int)((float)socketTimeoutToBeUsed + api.getTimeoutDeltaFactor() * (float)socketTimeoutToBeUsed);
        }
        return RequestConfig.custom().setConnectTimeout(server.getConnectTimeout()).setConnectionRequestTimeout(server.getConnectionRequestTimeout()).setSocketTimeout(socketTimeoutToBeUsed).build();
    }

    private URI generateURI(Server server, Api api, RequestObject request) throws URISyntaxException {
        if (server.getPort() == -1) {
            return new URIBuilder().setScheme(server.isHttps() ? "https" : "http").setHost(server.getHost()).setPath(this.resolvePath(server, api, request)).setParameters(this.getQueryParams(server, api, request)).build();
        }
        return new URIBuilder().setScheme(server.isHttps() ? "https" : "http").setHost(server.getHost()).setPort(server.getPort()).setPath(this.resolvePath(server, api, request)).setParameters(this.getQueryParams(server, api, request)).build();
    }

    private String resolvePath(Server server, Api api, RequestObject request) {
        String uri = api.getPath();
        if (!Strings.isNullOrEmpty((String)uri) && request.getPathParam() != null) {
            uri = StrSubstitutor.replace((Object)api.getPath(), request.getPathParam());
        }
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = "/";
        }
        return uri.startsWith("/") ? uri : "/" + uri;
    }

    private List<NameValuePair> getQueryParams(Server server, Api api, RequestObject request) {
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
        if (null != request.getQueryParam()) {
            request.getQueryParam().forEach((key, values) -> values.forEach(value -> queryParams.add((NameValuePair)new BasicNameValuePair(key, this.stringHelper.stringify(value)))));
        }
        return queryParams;
    }
}

