/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.util;

import com.google.inject.Key;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.Safe;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.github.devlibx.easy.http.IRequestProcessor;
import io.github.devlibx.easy.http.RequestObject;
import io.github.devlibx.easy.http.config.Api;
import io.github.devlibx.easy.http.config.Config;
import io.github.devlibx.easy.http.exception.EasyHttpExceptions;
import io.github.devlibx.easy.http.module.Async;
import io.github.devlibx.easy.http.module.Sync;
import io.github.devlibx.easy.http.registry.ApiRegistry;
import io.github.devlibx.easy.http.registry.ServerRegistry;
import io.github.devlibx.easy.http.util.Call;
import io.github.devlibx.easy.http.util.IEasyHttpImplementation;
import io.github.devlibx.easy.resilience.IResilienceManager;
import io.github.devlibx.easy.resilience.IResilienceProcessor;
import io.github.devlibx.easy.resilience.ResilienceManager;
import io.reactivex.rxjava3.core.Observable;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EasyHttpObject
implements IEasyHttpImplementation {
    private static final Logger log = LoggerFactory.getLogger(EasyHttpObject.class);
    private final Map<String, IRequestProcessor> requestProcessors = new HashMap<String, IRequestProcessor>();
    private final Map<String, IResilienceProcessor> resilienceProcessors = new HashMap<String, IResilienceProcessor>();
    private IResilienceManager resilienceManager;
    private final Lock resilienceManagerLock = new ReentrantLock();
    private IMetrics metrics;

    EasyHttpObject() {
    }

    @Override
    public void shutdown() {
        this.requestProcessors.forEach((key, requestProcessor) -> Safe.safe(requestProcessor::shutdown));
        this.requestProcessors.clear();
        this.resilienceProcessors.clear();
        this.resilienceManager = null;
    }

    @Override
    public void setup(Config config) {
        this.setup(config, null);
    }

    @Override
    public void setup(Config config, IMetrics metricsObj) {
        try {
            this.metrics = this.metrics == null ? (IMetrics)ApplicationContext.getInstance(IMetrics.class) : metricsObj;
        }
        catch (Exception e) {
            this.metrics = new IMetrics.NoOpMetrics();
        }
        if (this.metrics == null) {
            this.metrics = new IMetrics.NoOpMetrics();
        }
        ServerRegistry serverRegistry = (ServerRegistry)ApplicationContext.getInstance(ServerRegistry.class);
        serverRegistry.configure(config);
        ApiRegistry apiRegistry = (ApiRegistry)ApplicationContext.getInstance(ApiRegistry.class);
        apiRegistry.configure(config);
        this.ensureResilienceManager();
        serverRegistry.getServerMap().forEach((serverName, server) -> {
            server.setName((String)serverName);
            apiRegistry.getApiMap().forEach((apiName, api) -> {
                api.setName((String)apiName);
                String key = serverName + "-" + apiName;
                api.getConfigPreProcessorList().forEach(processor -> processor.process((String)apiName, (Api)api));
                IRequestProcessor requestProcessor = null;
                requestProcessor = api.isAsync() ? (IRequestProcessor)ApplicationContext.getInstance((Key)Key.get(IRequestProcessor.class, Async.class)) : (IRequestProcessor)ApplicationContext.getInstance((Key)Key.get(IRequestProcessor.class, Sync.class));
                this.requestProcessors.put(key, requestProcessor);
                IResilienceManager.ResilienceCallConfig callConfig = IResilienceManager.ResilienceCallConfig.withDefaults().id(key).concurrency(api.getConcurrency()).timeout(api.getTimeout()).queueSize(api.getQueueSize()).useSemaphore(api.isAsync()).waitDurationInOpenState(api.getWaitBeforeClosingCircuitAfterError()).build();
                IResilienceProcessor resilienceProcessor = this.resilienceManager.getOrCreate(callConfig);
                this.resilienceProcessors.put(key, resilienceProcessor);
            });
        });
        serverRegistry.getServerMap().forEach((serverName, server) -> apiRegistry.getApiMap().forEach((apiName, api) -> {
            if (!api.isNoWarmUp()) {
                // empty if block
            }
            log.debug("service={} api={} warm-up is disabled. The very first call to {}.{} may timeout or fail if api timeout is small", new Object[]{server, api, server, api});
        }));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T callSync(Call<T> call) {
        Object object;
        long start = System.currentTimeMillis();
        String key = call.getServer() + "_" + call.getApi() + "_call_error_time";
        String code = "200";
        try {
            Object t = this.internalCall(call).blockingFirst();
            key = call.getServer() + "_" + call.getApi() + "_call_time";
            object = t;
        }
        catch (EasyHttpExceptions.EasyResilienceException e) {
            try {
                Optional<EasyHttpExceptions.EasyResilienceException> ex = EasyHttpExceptions.easyEasyResilienceException(e);
                if (!ex.isPresent()) {
                    code = "500-resilience-unknown";
                    throw new EasyHttpExceptions.EasyHttpRequestException(e);
                }
                if (ex.get() instanceof EasyHttpExceptions.EasyResilienceRequestTimeoutException) {
                    code = "500-request-timeout";
                    throw ex.get();
                }
                if (ex.get() instanceof EasyHttpExceptions.EasyResilienceOverflowException) {
                    code = "500-request-overflow";
                    throw ex.get();
                }
                if (ex.get() instanceof EasyHttpExceptions.EasyResilienceCircuitOpenException) {
                    code = "500-circuit-open";
                    throw ex.get();
                }
                if (!(ex.get() instanceof EasyHttpExceptions.EasyResilienceException)) throw ex.get();
                code = "500-resilience-unknown";
                throw ex.get();
                catch (EasyHttpExceptions.EasyHttpRequestException e2) {
                    code = e2.getStatusCode() + "";
                    throw e2;
                }
                catch (Exception e3) {
                    ex = EasyHttpExceptions.easyEasyResilienceException(e3);
                    if (ex.isPresent()) {
                        if (ex.get() instanceof EasyHttpExceptions.EasyResilienceRequestTimeoutException) {
                            code = "500-request-timeout";
                            throw ex.get();
                        }
                        if (ex.get() instanceof EasyHttpExceptions.EasyResilienceOverflowException) {
                            code = "500-request-overflow";
                            throw ex.get();
                        }
                        if (ex.get() instanceof EasyHttpExceptions.EasyResilienceCircuitOpenException) {
                            code = "500-circuit-open";
                            throw ex.get();
                        }
                        if (!(ex.get() instanceof EasyHttpExceptions.EasyResilienceException)) throw ex.get();
                        code = "500-resilience-unknown";
                        throw ex.get();
                    }
                    if (e3 instanceof SocketTimeoutException) {
                        code = "500-socket-timeout";
                        throw EasyHttpExceptions.easyEasyResilienceException(e3).orElseThrow(() -> new RuntimeException(e3));
                    }
                    code = "500-unknown";
                    throw EasyHttpExceptions.easyEasyResilienceException(e3).orElseThrow(() -> new RuntimeException(e3));
                }
            }
            catch (Throwable throwable) {
                this.metrics.observe(key, (double)(System.currentTimeMillis() - start));
                this.metrics.inc("easy_http_sync", new String[]{"server", call.getServer(), "api", call.getApi(), "code", "" + code});
                throw throwable;
            }
        }
        this.metrics.observe(key, (double)(System.currentTimeMillis() - start));
        this.metrics.inc("easy_http_sync", new String[]{"server", call.getServer(), "api", call.getApi(), "code", "" + code});
        return (T)object;
    }

    @Override
    public <T> Observable<T> callAsync(Call<T> call) {
        long start = System.currentTimeMillis();
        return Observable.create(observableEmitter -> this.internalCall(call).subscribe(t -> {
            this.metrics.observe(call.getServer() + "_" + call.getApi() + "_call_time", (double)(System.currentTimeMillis() - start));
            observableEmitter.onNext(t);
            observableEmitter.onComplete();
        }, throwable -> {
            Optional<EasyHttpExceptions.EasyResilienceException> err;
            Optional<EasyHttpExceptions.EasyResilienceException> ex;
            this.metrics.observe(call.getServer() + "_" + call.getApi() + "_call_error_time", (double)(System.currentTimeMillis() - start));
            Exception e = throwable instanceof EasyHttpExceptions.EasyResilienceException ? ((ex = EasyHttpExceptions.easyEasyResilienceException(throwable)).isPresent() ? (Exception)ex.get() : new EasyHttpExceptions.EasyHttpRequestException((Throwable)throwable)) : (throwable instanceof EasyHttpExceptions.EasyHttpRequestException ? (EasyHttpExceptions.EasyHttpRequestException)throwable : ((err = EasyHttpExceptions.easyEasyResilienceException(throwable)).isPresent() ? (Exception)err.get() : new RuntimeException((Throwable)throwable)));
            observableEmitter.onError((Throwable)e);
        }).dispose());
    }

    private <T> Observable<T> internalCall(Call<T> call) {
        String server = call.getServer();
        String api = call.getApi();
        String key = server + "-" + api;
        if (this.requestProcessors.get(key) == null) {
            return Observable.error((Throwable)new RuntimeException("server=" + server + " api=" + api + " is not registered"));
        }
        RequestObject requestObject = new RequestObject();
        requestObject.setServer(server);
        requestObject.setApi(api);
        requestObject.setPathParam(call.getPathParams());
        requestObject.setQueryParam(call.getQueryParam());
        requestObject.setHeaders(call.getHeaders());
        requestObject.setBody(call.getBodyAsByteArray());
        requestObject.setResponseBuilder(call.getResponseBuilder());
        Observable observable = this.requestProcessors.get(server + "-" + api).process(requestObject).flatMap(responseObject -> {
            Object objectToReturn = call.getResponseBuilder().apply(responseObject.getBody());
            return Observable.just(objectToReturn);
        });
        return this.resilienceProcessors.get(key).executeObservable(key, observable, call.getResponseClass());
    }

    private void ensureResilienceManager() {
        if (this.resilienceManager == null) {
            this.resilienceManagerLock.lock();
            if (this.resilienceManager == null) {
                try {
                    this.resilienceManager = (IResilienceManager)ApplicationContext.getInstance(IResilienceManager.class);
                }
                catch (Exception e) {
                    this.resilienceManager = new ResilienceManager();
                }
            }
            this.resilienceManagerLock.unlock();
        }
    }
}

